/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.states.match;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lonelycoders.ufohippa.client.Match;
import lonelycoders.ufohippa.client.levels.LevelManager;
import lonelycoders.ufohippa.client.sound.SoundManager;
import lonelycoders.ufohippa.client.states.match.ClientRoundState;
import lonelycoders.ufohippa.client.states.match.Player;
import lonelycoders.ufohippa.game.level.Level;
import lonelycoders.ufohippa.game.level.LevelDescriptor;
import lonelycoders.ufohippa.game.util.ColorRGB;
import lonelycoders.ufohippa.network.CommandHandler;
import lonelycoders.ufohippa.network.CommandState;
import lonelycoders.ufohippa.network.State;
import lonelycoders.ufohippa.network.commands.lobby.AllBasicSettingsCommand;
import lonelycoders.ufohippa.network.commands.match.ClientDroppedCommand;
import lonelycoders.ufohippa.network.commands.match.MatchStartingCommand;
import lonelycoders.ufohippa.network.commands.match.MatchStartingReplyCommand;
import lonelycoders.ufohippa.network.commands.match.SendLevelsCommand;
import lonelycoders.ufohippa.network.commands.match.SendLevelsReplyCommand;
import lonelycoders.ufohippa.network.commands.match.SendPlayersCommand;

public class ClientMatchStartingState
extends CommandState {
    private final SoundManager soundManager;
    private final LevelManager levelManager;
    private final ClientRoundState nextState;
    private Map<String, Player> players;
    private final List<Listener> listeners = new ArrayList<Listener>();
    private final CommandHandler matchStartingHandler = new MatchStartingCommand.Handler(){

        @Override
        public State process(MatchStartingCommand payload) {
            ClientMatchStartingState.this.soundManager.stopMusic(true);
            ClientMatchStartingState.this.sendCommand(new MatchStartingReplyCommand());
            return null;
        }
    };
    private final CommandHandler allBasicSettingsHandler = new AllBasicSettingsCommand.Handler(){

        @Override
        public State process(AllBasicSettingsCommand payload) {
            ClientMatchStartingState.this.nextState.setPlayingTime(payload.getPlayingTime());
            return null;
        }
    };
    private final CommandHandler sendPlayersHandler = new SendPlayersCommand.Handler(){

        @Override
        public State process(SendPlayersCommand payload) {
            int playerCount = payload.getPlayerCount();
            String[] playerNames = payload.getPlayerNames();
            ColorRGB[] playerColors = payload.getPlayerColors();
            ClientMatchStartingState.this.players = new HashMap();
            for (int i = 0; i < playerCount; ++i) {
                String playerName = playerNames[i];
                ClientMatchStartingState.this.players.put(playerName, new Player(i, playerName, playerColors[i]));
            }
            return null;
        }
    };
    private final CommandHandler sendLevelsHandler = new SendLevelsCommand.Handler(){

        @Override
        public State process(SendLevelsCommand payload) {
            String[] levelNames = payload.getLevelNames();
            Level[] levels = new Level[levelNames.length];
            for (int i = 0; i < levels.length; ++i) {
                LevelDescriptor levelDescriptor = ClientMatchStartingState.this.levelManager.getLevel(levelNames[i]);
                levels[i] = levelDescriptor.load();
            }
            Match match = new Match(ClientMatchStartingState.this.players, levels);
            ClientMatchStartingState.this.nextState.setMatch(match);
            ClientMatchStartingState.this.notifyMatchReady(match);
            ClientMatchStartingState.this.waitForListeners();
            ClientMatchStartingState.this.sendCommand(new SendLevelsReplyCommand());
            return ClientMatchStartingState.this.nextState;
        }
    };
    private final CommandHandler dropHandler = new ClientDroppedCommand.Handler(){

        @Override
        public State process(ClientDroppedCommand payload) {
            for (String playerName : payload.getPlayerNames()) {
                if (!ClientMatchStartingState.this.players.containsKey(playerName)) continue;
                ClientMatchStartingState.this.players.remove(playerName);
            }
            return null;
        }
    };

    public void setPlayers(int playerCount, String[] playerNames, ColorRGB[] playerColors) {
    }

    public ClientMatchStartingState(SoundManager soundManager, LevelManager levelManager, ClientRoundState nextState) {
        super("Starting match", new CommandHandler[0]);
        this.soundManager = soundManager;
        this.levelManager = levelManager;
        this.nextState = nextState;
        this.registerHandlers(this.matchStartingHandler, this.allBasicSettingsHandler, this.sendPlayersHandler, this.sendLevelsHandler, this.dropHandler);
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.notifyMatchStarting();
        }
    }

    private void notifyMatchStarting() {
        for (Listener listener : this.listeners) {
            listener.matchStarting();
        }
    }

    private void notifyMatchReady(Match match) {
        for (Listener listener : this.listeners) {
            listener.matchReady(match);
        }
    }

    private void waitForListeners() {
        for (Listener listener : this.listeners) {
            listener.waitForReady();
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public static interface Listener {
        public void matchStarting();

        public void matchReady(Match var1);

        public void waitForReady();
    }
}

