/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.sound.fmod;

public class FmodException
extends RuntimeException {
    public FmodException(String message) {
        super(message);
    }

    public FmodException(int result) {
        throw new FmodException(this.getErrorString(result));
    }

    private String getErrorString(int result) {
        return Result.values()[result].getDescription();
    }

    public static void check(int result) {
        if (result != 0) {
            throw new FmodException(result);
        }
    }

    static enum Result {
        FMOD_OK(0, "No errors."),
        FMOD_ERR_ALREADYLOCKED(1, "Tried to call lock a second time before unlock was called."),
        FMOD_ERR_BADCOMMAND(2, "Tried to call a function on a data type that does not allow this type of functionality (ie calling Sound::lock on a streaming sound)."),
        FMOD_ERR_CDDA_DRIVERS(3, "Neither NTSCSI nor ASPI could be initialised."),
        FMOD_ERR_CDDA_INIT(4, "An error occurred while initialising the CDDA subsystem."),
        FMOD_ERR_CDDA_INVALID_DEVICE(5, "Couldn't find the specified device."),
        FMOD_ERR_CDDA_NOAUDIO(6, "No audio tracks on the specified disc."),
        FMOD_ERR_CDDA_NODEVICES(7, "No CD/DVD devices were found."),
        FMOD_ERR_CDDA_NODISC(8, "No disc present in the specified drive."),
        FMOD_ERR_CDDA_READ(9, "A CDDA read error occurred."),
        FMOD_ERR_CHANNEL_ALLOC(10, "Error trying to allocate a channel."),
        FMOD_ERR_CHANNEL_STOLEN(11, "The specified channel has been reused to play another sound."),
        FMOD_ERR_COM(12, "A Win32 COM related error occured. COM failed to initialize or a QueryInterface failed meaning a Windows codec or driver was not installed properly."),
        FMOD_ERR_DMA(13, "DMA Failure.  See debug output for more information."),
        FMOD_ERR_DSP_CONNECTION(14, "DSP connection error.  Connection possibly caused a cyclic dependancy.  Or tried to connect a tree too many units deep (more than 128)."),
        FMOD_ERR_DSP_FORMAT(15, "DSP Format error.  A DSP unit may have attempted to connect to this network with the wrong format."),
        FMOD_ERR_DSP_NOTFOUND(16, "DSP connection error.  Couldn't find the DSP unit specified."),
        FMOD_ERR_DSP_RUNNING(17, "DSP error.  Cannot perform this operation while the network is in the middle of running.  This will most likely happen if a connection or disconnection is attempted in a DSP callback."),
        FMOD_ERR_DSP_TOOMANYCONNECTIONS(18, "DSP connection error.  The unit being connected to or disconnected should only have 1 input or output."),
        FMOD_ERR_FILE_BAD(19, "Error loading file."),
        FMOD_ERR_FILE_COULDNOTSEEK(20, "Couldn't perform seek operation.  This is a limitation of the medium (ie netstreams) or the file format."),
        FMOD_ERR_FILE_DISKEJECTED(21, "Media was ejected while reading."),
        FMOD_ERR_FILE_EOF(22, "End of file unexpectedly reached while trying to read essential data (truncated data?)."),
        FMOD_ERR_FILE_NOTFOUND(23, "File not found."),
        FMOD_ERR_FILE_UNWANTED(24, "Unwanted file access occured."),
        FMOD_ERR_FORMAT(25, "Unsupported file or audio format."),
        FMOD_ERR_HTTP(26, "A HTTP error occurred. This is a catch-all for HTTP errors not listed elsewhere."),
        FMOD_ERR_HTTP_ACCESS(27, "The specified resource requires authentication or is forbidden."),
        FMOD_ERR_HTTP_PROXY_AUTH(28, "Proxy authentication is required to access the specified resource."),
        FMOD_ERR_HTTP_SERVER_ERROR(29, "A HTTP server error occurred."),
        FMOD_ERR_HTTP_TIMEOUT(30, "The HTTP request timed out."),
        FMOD_ERR_INITIALIZATION(31, "FMOD was not initialized correctly to support this function."),
        FMOD_ERR_INITIALIZED(32, "Cannot call this command after System::init."),
        FMOD_ERR_INTERNAL(33, "An error occured that wasn't supposed to.  Contact support."),
        FMOD_ERR_INVALID_ADDRESS(34, "On Xbox 360, this memory address passed to FMOD must be physical, (ie allocated with XPhysicalAlloc.)"),
        FMOD_ERR_INVALID_FLOAT(35, "Value passed in was a NaN, Inf or denormalized float."),
        FMOD_ERR_INVALID_HANDLE(36, "An invalid object handle was used."),
        FMOD_ERR_INVALID_PARAM(37, "An invalid parameter was passed to this function."),
        FMOD_ERR_INVALID_POSITION(38, "An invalid seek position was passed to this function."),
        FMOD_ERR_INVALID_SPEAKER(39, "An invalid speaker was passed to this function based on the current speaker mode."),
        FMOD_ERR_INVALID_SYNCPOINT(40, "The syncpoint did not come from this sound handle."),
        FMOD_ERR_INVALID_VECTOR(41, "The vectors passed in are not unit length, or perpendicular."),
        FMOD_ERR_IRX(42, "PS2 only.  fmodex.irx failed to initialize.  This is most likely because you forgot to load it."),
        FMOD_ERR_MAXAUDIBLE(43, "Reached maximum audible playback count for this sound's soundgroup."),
        FMOD_ERR_MEMORY(44, "Not enough memory or resources."),
        FMOD_ERR_MEMORY_CANTPOINT(45, "Can't use FMOD_OPENMEMORY_POINT on non PCM source data, or non mp3/xma/adpcm data if FMOD_CREATECOMPRESSEDSAMPLE was used."),
        FMOD_ERR_MEMORY_IOP(46, "PS2 only.  Not enough memory or resources on PlayStation 2 IOP ram."),
        FMOD_ERR_MEMORY_SRAM(47, "Not enough memory or resources on console sound ram."),
        FMOD_ERR_NEEDS2D(48, "Tried to call a command on a 3d sound when the command was meant for 2d sound."),
        FMOD_ERR_NEEDS3D(49, "Tried to call a command on a 2d sound when the command was meant for 3d sound."),
        FMOD_ERR_NEEDSHARDWARE(50, "Tried to use a feature that requires hardware support.  (ie trying to play a VAG compressed sound in software on PS2)."),
        FMOD_ERR_NEEDSSOFTWARE(51, "Tried to use a feature that requires the software engine.  Software engine has either been turned off, or command was executed on a hardware channel which does not support this feature."),
        FMOD_ERR_NET_CONNECT(52, "Couldn't connect to the specified host."),
        FMOD_ERR_NET_SOCKET_ERROR(53, "A socket error occurred.  This is a catch-all for socket-related errors not listed elsewhere."),
        FMOD_ERR_NET_URL(54, "The specified URL couldn't be resolved."),
        FMOD_ERR_NET_WOULD_BLOCK(55, "Operation on a non-blocking socket could not complete immediately."),
        FMOD_ERR_NOTREADY(56, "Operation could not be performed because specified sound/DSP connection is not ready."),
        FMOD_ERR_OUTPUT_ALLOCATED(57, "Error initializing output device, but more specifically, the output device is already in use and cannot be reused."),
        FMOD_ERR_OUTPUT_CREATEBUFFER(58, "Error creating hardware sound buffer."),
        FMOD_ERR_OUTPUT_DRIVERCALL(59, "A call to a standard soundcard driver failed, which could possibly mean a bug in the driver or resources were missing or exhausted."),
        FMOD_ERR_OUTPUT_ENUMERATION(60, "Error enumerating the available driver list. List may be inconsistent due to a recent device addition or removal."),
        FMOD_ERR_OUTPUT_FORMAT(61, "Soundcard does not support the minimum features needed for this soundsystem (16bit stereo output)."),
        FMOD_ERR_OUTPUT_INIT(62, "Error initializing output device."),
        FMOD_ERR_OUTPUT_NOHARDWARE(63, "FMOD_HARDWARE was specified but the sound card does not have the resources necessary to play it."),
        FMOD_ERR_OUTPUT_NOSOFTWARE(64, "Attempted to create a software sound but no software channels were specified in System::init."),
        FMOD_ERR_PAN(65, "Panning only works with mono or stereo sound sources."),
        FMOD_ERR_PLUGIN(66, "An unspecified error has been returned from a 3rd party plugin."),
        FMOD_ERR_PLUGIN_INSTANCES(67, "The number of allowed instances of a plugin has been exceeded."),
        FMOD_ERR_PLUGIN_MISSING(68, "A requested output, dsp unit type or codec was not available."),
        FMOD_ERR_PLUGIN_RESOURCE(69, "A resource that the plugin requires cannot be found. (ie the DLS file for MIDI playback)"),
        FMOD_ERR_PRELOADED(70, "The specified sound is still in use by the event system, call EventSystem::unloadFSB before trying to release it."),
        FMOD_ERR_PROGRAMMERSOUND(71, "The specified sound is still in use by the event system, wait for the event which is using it finish with it."),
        FMOD_ERR_RECORD(72, "An error occured trying to initialize the recording device."),
        FMOD_ERR_REVERB_INSTANCE(73, "Specified Instance in FMOD_REVERB_PROPERTIES couldn't be set. Most likely because it is an invalid instance number, or another application has locked the EAX4 FX slot."),
        FMOD_ERR_SUBSOUND_ALLOCATED(74, "This subsound is already being used by another sound, you cannot have more than one parent to a sound.  Null out the other parent's entry first."),
        FMOD_ERR_SUBSOUND_CANTMOVE(75, "Shared subsounds cannot be replaced or moved from their parent stream, such as when the parent stream is an FSB file."),
        FMOD_ERR_SUBSOUND_MODE(76, "The subsound's mode bits do not match with the parent sound's mode bits.  See documentation for function that it was called with."),
        FMOD_ERR_SUBSOUNDS(77, "The error occured because the sound referenced contains subsounds.  The operation cannot be performed on a parent sound, or a parent sound was played without setting up a sentence first."),
        FMOD_ERR_TAGNOTFOUND(78, "The specified tag could not be found or there are no tags."),
        FMOD_ERR_TOOMANYCHANNELS(79, "The sound created exceeds the allowable input channel count.  This can be increased using the maxinputchannels parameter in System::setSoftwareFormat."),
        FMOD_ERR_UNIMPLEMENTED(80, "Something in FMOD hasn't been implemented when it should be! contact support!"),
        FMOD_ERR_UNINITIALIZED(81, "This command failed because System::init or System::setDriver was not called."),
        FMOD_ERR_UNSUPPORTED(82, "A command issued was not supported by this object.  Possibly a plugin without certain callbacks specified."),
        FMOD_ERR_UPDATE(83, "An error caused by System::update occured."),
        FMOD_ERR_VERSION(84, "The version number of this file format is not supported."),
        FMOD_ERR_EVENT_FAILED(85, "An Event failed to be retrieved, most likely due to 'just fail' being specified as the max playbacks behavior."),
        FMOD_ERR_EVENT_INFOONLY(86, "Can't execute this command on an EVENT_INFOONLY event."),
        FMOD_ERR_EVENT_INTERNAL(87, "An error occured that wasn't supposed to.  See debug log for reason."),
        FMOD_ERR_EVENT_MAXSTREAMS(88, "Event failed because 'Max streams' was hit when FMOD_EVENT_INIT_FAIL_ON_MAXSTREAMS was specified."),
        FMOD_ERR_EVENT_MISMATCH(89, "FSB mismatches the FEV it was compiled with, the stream/sample mode it was meant to be created with was different, or the FEV was built for a different platform."),
        FMOD_ERR_EVENT_NAMECONFLICT(90, "A category with the same name already exists."),
        FMOD_ERR_EVENT_NOTFOUND(91, "The requested event, event group, event category or event property could not be found."),
        FMOD_ERR_EVENT_NEEDSSIMPLE(92, "Tried to call a function on a complex event that's only supported by simple events."),
        FMOD_ERR_EVENT_GUIDCONFLICT(93, "An event with the same GUID already exists."),
        FMOD_ERR_EVENT_ALREADY_LOADED(94, "The specified project has already been loaded. Having multiple copies of the same project loaded simultaneously is forbidden."),
        FMOD_ERR_MUSIC_UNINITIALIZED(95, "Music system is not initialized probably because no music data is loaded."),
        FMOD_ERR_MUSIC_NOTFOUND(96, "The requested music entity could not be found."),
        FMOD_ERR_MUSIC_NOCALLBACK(97, "The music callback is required, but it has not been set.");

        private int value;
        private String description;

        private Result(int value, String description) {
            this.value = value;
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

