/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.sound;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import lonelycoders.ufohippa.client.sound.Sound;
import lonelycoders.ufohippa.client.sound.SoundManager;
import lonelycoders.ufohippa.client.sound.SoundSystem;
import lonelycoders.ufohippa.client.sound.fmod.FmodException;
import lonelycoders.ufohippa.client.sound.fmod.FmodSoundSystem;
import lonelycoders.ufohippa.general.Logger;

public class SoundManagerImpl
implements SoundManager {
    private static final File musicPath = new File("music");
    private static final String soundPath = "sounds/";
    private final SoundSystem soundSystem = new FmodSoundSystem();
    private final List<Sound> oldGameMusics = new ArrayList<Sound>();
    private final List<Sound> newGameMusics = new ArrayList<Sound>();
    private final List<Sound> menuMusics = new ArrayList<Sound>();
    private final Sound soundBoxAppear;
    private final Sound soundBulletHit;
    private final Sound soundRicochet;
    private final Sound[] soundShoot;
    private final Sound soundStealth;
    private final Sound soundTeleport;
    private final Sound soundTick;
    private final Sound soundTimeOver;
    private final Sound soundUfoCollision;
    private final Sound soundWallCollision;
    private volatile Sound currentMusic;
    private final Timer fadeTimer = new Timer();
    private volatile TimerTask fadeTask;

    public SoundManagerImpl() {
        File[] oldGameMusicFiles = new File(musicPath, "old").listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.isDirectory() && !file.getName().startsWith(".");
            }
        });
        File[] newGameMusicFiles = new File(musicPath, "new").listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.isDirectory() && !file.getName().startsWith(".");
            }
        });
        File[] menuMusicFiles = new File(musicPath, "menu").listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.isDirectory() && !file.getName().startsWith(".");
            }
        });
        for (File file : oldGameMusicFiles) {
            try {
                this.oldGameMusics.add(this.soundSystem.loadStream(file, true));
            }
            catch (FmodException e) {
                Logger.exception(e);
            }
        }
        for (File file : newGameMusicFiles) {
            try {
                this.newGameMusics.add(this.soundSystem.loadStream(file, true));
            }
            catch (FmodException e) {
                Logger.exception(e);
            }
        }
        for (File file : menuMusicFiles) {
            try {
                this.menuMusics.add(this.soundSystem.loadStream(file, true));
            }
            catch (FmodException e) {
                Logger.exception(e);
            }
        }
        this.soundBoxAppear = this.soundSystem.loadSample("sounds/BoxAppear.wav");
        this.soundBulletHit = this.soundSystem.loadSample("sounds/BulletHit.wav");
        this.soundRicochet = this.soundSystem.loadSample("sounds/Ricochet.wav");
        this.soundShoot = new Sound[]{this.soundSystem.loadSample("sounds/Shoot1.wav"), this.soundSystem.loadSample("sounds/Shoot2.wav")};
        this.soundStealth = this.soundSystem.loadSample("sounds/Stealth.wav");
        this.soundTeleport = this.soundSystem.loadSample("sounds/Teleport.wav");
        this.soundTick = this.soundSystem.loadSample("sounds/Tick.wav");
        this.soundTimeOver = this.soundSystem.loadSample("sounds/TimeOver.wav");
        this.soundUfoCollision = this.soundSystem.loadSample("sounds/UfoCollision.wav");
        this.soundWallCollision = this.soundSystem.loadSample("sounds/WallCollision.wav");
    }

    @Override
    public synchronized void shutdown() {
        this.stopFade();
        this.soundSystem.shutdown();
        this.fadeTimer.cancel();
    }

    @Override
    public synchronized void playGameMusic(SoundManager.MusicType type) {
        this.stopFade();
        switch (type) {
            case OLD: {
                this.currentMusic = this.oldGameMusics.get((int)(Math.random() * (double)this.oldGameMusics.size()));
                break;
            }
            case NEW: {
                this.currentMusic = this.newGameMusics.get((int)(Math.random() * (double)this.newGameMusics.size()));
            }
        }
        Logger.info("Playing game music: " + this.currentMusic.getName());
        this.currentMusic.play();
    }

    @Override
    public synchronized void playMenuMusic() {
        this.stopFade();
        this.currentMusic = this.menuMusics.get((int)(Math.random() * (double)this.menuMusics.size()));
        Logger.info("Playing menu music: " + this.currentMusic.getName());
        this.currentMusic.play();
    }

    private void stopFade() {
        if (this.fadeTask != null) {
            this.fadeTask.cancel();
            this.fadeTask = null;
        }
        if (this.currentMusic != null) {
            this.currentMusic.stop();
            this.currentMusic = null;
        }
    }

    @Override
    public synchronized void stopMusic(boolean fade) {
        Logger.info("Fading out music");
        if (this.currentMusic != null) {
            int FADE_RATE = 10;
            int FADE_LENGTH = 2000;
            this.fadeTask = new TimerTask(){
                private int count = 0;

                @Override
                public void run() {
                    float volume = Math.max(0.0f, 1.0f - (float)this.count * 10.0f / 2000.0f);
                    SoundManagerImpl.this.currentMusic.setVolume(volume);
                    ++this.count;
                    if (volume == 0.0f) {
                        SoundManagerImpl.this.stopFade();
                        this.cancel();
                    }
                }
            };
            this.fadeTimer.scheduleAtFixedRate(this.fadeTask, 0L, 10L);
        }
    }

    @Override
    public synchronized void playEffectBoxAppear() {
        this.soundBoxAppear.play();
    }

    @Override
    public synchronized void playEffectBulletHit() {
        this.soundBulletHit.play();
    }

    @Override
    public synchronized void playEffectRicochet() {
        this.soundRicochet.play();
    }

    @Override
    public synchronized void playEffectShoot() {
        this.playRandomSound(this.soundShoot);
    }

    private void playRandomSound(Sound[] sounds) {
        sounds[(int)(Math.random() * (double)sounds.length)].play();
    }

    @Override
    public synchronized void playEffectStealth() {
        this.soundStealth.play();
    }

    @Override
    public synchronized void playEffectTick() {
        this.soundTick.play();
    }

    @Override
    public synchronized void playEffectTimeOver() {
        this.soundTimeOver.play();
    }

    @Override
    public synchronized void playEffectUfoCollision() {
        this.soundUfoCollision.play();
    }

    @Override
    public synchronized void playEffectWallCollision() {
        this.soundWallCollision.play();
    }

    @Override
    public synchronized void playEffectTeleport() {
        this.soundTeleport.play();
    }
}

