/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.renderer.gl.tiles.cube;

import javax.media.opengl.GL;
import lonelycoders.ufohippa.client.gl.GameResources;
import lonelycoders.ufohippa.client.gl.MeshGL;
import lonelycoders.ufohippa.client.gl.RenderOptimizer;
import lonelycoders.ufohippa.client.gl.Shader;
import lonelycoders.ufohippa.client.gl.texturing.Texture;
import lonelycoders.ufohippa.client.renderer.gl.Renderable;
import lonelycoders.ufohippa.client.resource.ResourceManager;
import lonelycoders.ufohippa.game.util.Vector3;

public class RoundCube
implements Renderable {
    private final MeshGL mesh;
    private final Shader phongShader;
    private final Texture texture;

    public RoundCube(ResourceManager resourceManager) {
        this.phongShader = resourceManager.getResource(GameResources.SHADER_PHONG_MULTILIGHT);
        this.texture = resourceManager.getResource(GameResources.WHITE_TEXTURE);
        this.mesh = resourceManager.getResource(GameResources.TILE_ROUNDED_CUBE);
    }

    @Override
    public void render(GL gl) {
        this.texture.bind(gl, this.phongShader, "texture");
        this.mesh.render(gl);
        this.texture.unbind(gl);
    }

    @Override
    public void render(RenderOptimizer renderOptimizer, Vector3 offset) {
        renderOptimizer.bindTexture(this.texture, this.phongShader, "texture");
        renderOptimizer.drawMesh(this.mesh, offset);
        renderOptimizer.unbindTexture(this.texture);
    }
}

