/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.renderer.gl;

import com.sun.opengl.util.j2d.TextRenderer;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import javax.media.opengl.GL;
import javax.media.opengl.GLDrawable;
import lonelycoders.ufohippa.client.Match;
import lonelycoders.ufohippa.client.gl.GLException;
import lonelycoders.ufohippa.client.gl.RenderPass;
import lonelycoders.ufohippa.client.gl.RenderTarget;
import lonelycoders.ufohippa.client.gl.Shader;
import lonelycoders.ufohippa.client.gl.UtilGL;
import lonelycoders.ufohippa.client.gl.texturing.CircleTexture;
import lonelycoders.ufohippa.client.gl.texturing.Texture;
import lonelycoders.ufohippa.client.renderer.AnimationTimer;
import lonelycoders.ufohippa.client.resource.ImmediateResourceLoader;
import lonelycoders.ufohippa.game.util.ColorRGB;

public class LoadingScreenRenderer
extends RenderPass {
    private static final Font TITLE_FONT = new Font("SansSerif", 1, 72);
    private final TextRenderer titleFontRenderer = new TextRenderer(TITLE_FONT, true, true);
    private final GLDrawable glPanel;
    private final AnimationTimer animationTimer;
    private final Shader backgroundShader;
    private final Texture backgroundTexture;

    public LoadingScreenRenderer(RenderTarget target, GLDrawable glPanel, GL gl, AnimationTimer animationTimer) {
        super(target);
        this.glPanel = glPanel;
        this.animationTimer = animationTimer;
        ImmediateResourceLoader immediateResourceLoader = new ImmediateResourceLoader(gl);
        this.backgroundShader = immediateResourceLoader.enqueue(new Shader("shaders/loading"));
        this.backgroundTexture = immediateResourceLoader.enqueue(new CircleTexture(32));
    }

    public void initialize(Match match) {
    }

    @Override
    protected void doRender(GL gl) throws GLException {
        this.startFrame(gl);
        int width = this.glPanel.getWidth();
        int height = this.glPanel.getHeight();
        this.setup2D(gl);
        this.drawBackground(gl, width, height);
        this.drawLoadingText(width, height);
        this.endFrame();
    }

    private void startFrame(GL gl) throws GLException {
        gl.glClear(256);
        UtilGL.checkErrors(gl);
    }

    private void setup2D(GL gl) {
        gl.glDisable(2896);
        gl.glDisable(2929);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
    }

    private void drawBackground(GL gl, int width, int height) {
        this.backgroundShader.bind(gl);
        this.backgroundShader.applyUniform(gl, "uTimer", this.animationTimer.getTime());
        this.backgroundShader.applyUniform(gl, "uColor1", new ColorRGB(0.3f, 0.3f, 0.3f));
        this.backgroundShader.applyUniform(gl, "uColor2", new ColorRGB(0.2f, 0.2f, 0.2f));
        this.backgroundTexture.bind(gl, this.backgroundShader, "uTexture");
        gl.glColor3f(1.0f, 1.0f, 1.0f);
        gl.glBegin(7);
        gl.glTexCoord2f(0.0f, 0.0f);
        gl.glVertex2f(-1.0f, -1.0f);
        gl.glTexCoord2f(width / 32, 0.0f);
        gl.glVertex2f(1.0f, -1.0f);
        gl.glTexCoord2f(width / 32, height / 32);
        gl.glVertex2f(1.0f, 1.0f);
        gl.glTexCoord2f(0.0f, height / 32);
        gl.glVertex2f(-1.0f, 1.0f);
        gl.glEnd();
        this.backgroundTexture.unbind(gl);
        this.backgroundShader.unbind(gl);
    }

    private void drawLoadingText(int width, int height) {
        String text = "Loading";
        TextRenderer renderer = this.titleFontRenderer;
        Rectangle2D loadingBounds = renderer.getBounds(text);
        renderer.beginRendering(width, height);
        renderer.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        renderer.draw(text, (int)((double)width - loadingBounds.getWidth()) / 2, height - 50 - (int)loadingBounds.getHeight());
        renderer.endRendering();
    }

    private void endFrame() {
    }
}

