/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.renderer.gl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import lonelycoders.ufohippa.client.gl.RenderTarget;
import lonelycoders.ufohippa.client.gl.Shader;
import lonelycoders.ufohippa.client.gl.texturing.RenderedTexture;
import lonelycoders.ufohippa.client.renderer.gl.FullScreenQuad;
import lonelycoders.ufohippa.client.resource.ResourceManager;
import lonelycoders.ufohippa.game.util.Vector2;
import lonelycoders.ufohippa.general.Logger;
import lonelycoders.ufohippa.util.ResourceUtil;

public class BlurPass
extends FullScreenQuad {
    public BlurPass(RenderTarget target, ResourceManager resourceManager, RenderedTexture source, Direction direction, Distribution distribution, int radius) throws IOException {
        super(target, source, BlurPass.createShader(resourceManager, source.getSize(), direction, distribution, radius), true);
    }

    public BlurPass(ResourceManager resourceManager, RenderedTexture source, Direction direction, Distribution distribution, int radius) throws IOException {
        this(null, resourceManager, source, direction, distribution, radius);
    }

    private static Shader createShader(ResourceManager resourceManager, Vector2 size, Direction direction, Distribution distribution, int radius) throws IOException {
        String line;
        InputStream is = ResourceUtil.getResource("shaders/blur.template");
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#")) {
                int i;
                Vector2 step = new Vector2(size);
                step.inverse();
                float sum = 0.0f;
                float[] weights = new float[radius * 2];
                float[] offsets = new float[radius * 2];
                for (i = 0; i < radius; ++i) {
                    float offset;
                    float weight;
                    float offsetDelta;
                    float weight1 = 0.0f;
                    float weight2 = 0.0f;
                    float offset1 = i * 2;
                    float offset2 = i * 2 + 1;
                    switch (distribution) {
                        case BOX: {
                            weight1 = BlurPass.getBoxValue(offset1, radius * 2);
                            weight2 = BlurPass.getBoxValue(offset2, radius * 2);
                            break;
                        }
                        case GAUSSIAN: {
                            weight1 = BlurPass.getGaussianValue(offset1, radius * radius);
                            weight2 = BlurPass.getGaussianValue(offset2, radius * radius);
                        }
                    }
                    if (i == 0) {
                        offsetDelta = weight2 / (weight1 * 0.5f + weight2);
                        weight = weight1 * 3.0f / 4.0f;
                    } else {
                        offsetDelta = weight2 / (weight1 + weight2);
                        weight = weight1;
                    }
                    offsets[radius + i] = offset = offset1 + offsetDelta;
                    weights[radius + i] = weight;
                    offsets[radius - 1 - i] = -offset;
                    weights[radius - 1 - i] = weight;
                    sum += (float)(i == 0 ? 1 : 2) * (weight * (1.0f - offsetDelta) + weight * offsetDelta);
                    Logger.detail("" + weight + " * " + offset + " (" + weight1 + "," + weight2 + ")");
                }
                for (i = 0; i < offsets.length; ++i) {
                    float offset = offsets[i];
                    float weight = weights[i] / sum;
                    float xOffset = offset * step.x * (float)(direction == Direction.HORIZONTAL ? 1 : 0);
                    float yOffset = offset * step.y * (float)(direction == Direction.VERTICAL ? 1 : 0);
                    lines.add(line.substring(2).replace("$weight", "" + Double.toString((double)weight * 1.0)).replace("$xOffset", "" + Double.toString(xOffset)).replace("$yOffset", "" + Double.toString(yOffset)) + "\n");
                }
                Logger.detail("sum = " + sum);
                continue;
            }
            lines.add(line + "\n");
        }
        String[] vertexShaderCode = Shader.getShaderCode("shaders/blur.vert");
        String[] fragmentShaderCode = lines.toArray(new String[lines.size()]);
        return resourceManager.getResourceLoader().enqueue(new Shader(vertexShaderCode, fragmentShaderCode, "shaders/blur", "shaders/blur.vert", "shaders/blur.template"));
    }

    private static float getBoxValue(float x, int sampleCount) {
        return 1.0f / (float)sampleCount;
    }

    private static float getGaussianValue(float x, int variance) {
        return (float)(1.0 / Math.sqrt((double)(2 * variance) * Math.PI) * Math.exp(-(x * x) / (float)(2 * variance)));
    }

    public static enum Distribution {
        BOX,
        GAUSSIAN;

    }

    public static enum Direction {
        HORIZONTAL,
        VERTICAL;

    }
}

