/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.lobby.gui;

import info.clearthought.layout.TableLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import lonelycoders.ufohippa.client.ApplicationFrame;
import lonelycoders.ufohippa.client.levels.LevelManager;
import lonelycoders.ufohippa.client.lobby.gui.CreditsPanel;
import lonelycoders.ufohippa.client.lobby.gui.HelpPanel;
import lonelycoders.ufohippa.client.lobby.gui.HostGamePanel;
import lonelycoders.ufohippa.client.lobby.gui.JoinGamePanel;
import lonelycoders.ufohippa.client.lobby.gui.LevelEditorPanel;
import lonelycoders.ufohippa.client.lobby.gui.LobbyMode;
import lonelycoders.ufohippa.client.sound.SoundManager;
import lonelycoders.ufohippa.general.Logger;
import lonelycoders.ufohippa.util.ImageUtil;

public class Lobby
extends JPanel {
    private static final String CARD_MENU = "Menu";
    private static final String CARD_HOST_GAME = "Host game";
    private static final String CARD_JOIN_GAME = "Join game";
    private static final String CARD_OPTIONS = "Options";
    private static final String CARD_LEVEL_EDITOR = "Level editor";
    private static final String CARD_HELP = "Help";
    private static final String CARD_CREDITS = "Credits";
    private final ApplicationFrame applicationFrame;
    private final Map<String, LobbyMode> cardModes = new HashMap<String, LobbyMode>();
    private final CardLayout cardLayout;
    private final HostGamePanel hostGame;
    private final JoinGamePanel joinGame;
    private final Image backgroundImage;

    public Lobby(ApplicationFrame applicationFrame, Object gameLock, SoundManager soundManager, LevelManager levelManager) {
        this.applicationFrame = applicationFrame;
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        BackToMenuCommand backCommand = new BackToMenuCommand();
        MainMenuPanel mainMenu = new MainMenuPanel();
        this.hostGame = new HostGamePanel(applicationFrame, gameLock, soundManager, levelManager, backCommand);
        this.joinGame = new JoinGamePanel(applicationFrame, gameLock, soundManager, levelManager, backCommand);
        LevelEditorPanel levelEditor = new LevelEditorPanel(applicationFrame, gameLock, levelManager, backCommand);
        CreditsPanel credits = new CreditsPanel(backCommand);
        HelpPanel help = new HelpPanel(backCommand);
        this.cardModes.put(CARD_MENU, mainMenu);
        this.cardModes.put(CARD_HOST_GAME, this.hostGame);
        this.cardModes.put(CARD_JOIN_GAME, this.joinGame);
        this.cardModes.put(CARD_LEVEL_EDITOR, levelEditor);
        this.cardModes.put(CARD_HELP, help);
        this.cardModes.put(CARD_CREDITS, credits);
        this.add((Component)mainMenu, CARD_MENU);
        this.add((Component)this.hostGame, CARD_HOST_GAME);
        this.add((Component)this.joinGame, CARD_JOIN_GAME);
        this.add((Component)levelEditor, CARD_LEVEL_EDITOR);
        this.add((Component)help, CARD_HELP);
        this.add((Component)credits, CARD_CREDITS);
        this.changeScreen(CARD_MENU);
        this.setPreferredSize(new Dimension(640, 480));
        BufferedImage backgroundImage = null;
        try {
            backgroundImage = ImageUtil.loadImageResource("Background.png");
        }
        catch (IOException e) {
            Logger.exception(e);
        }
        this.backgroundImage = backgroundImage;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.backgroundImage != null) {
            Rectangle clip = g.getClipBounds();
            int width = this.getWidth();
            int height = this.getHeight();
            int imgWidth = this.backgroundImage.getWidth(null);
            int imgHeight = this.backgroundImage.getHeight(null);
            g.drawImage(this.backgroundImage, clip.x, clip.y, clip.x + clip.width, clip.y + clip.height, clip.x * imgWidth / width, clip.y * imgHeight / height, (clip.x + clip.width) * imgWidth / width, (clip.y + clip.height) * imgHeight / height, null);
        } else {
            super.paintComponent(g);
        }
    }

    private void changeScreen(String card) {
        this.cardModes.get(card).activate();
        this.cardLayout.show(this, card);
    }

    public void reset() {
        this.hostGame.reset();
        this.joinGame.reset();
        this.changeScreen(CARD_MENU);
    }

    private class BackToMenuCommand
    implements Runnable {
        private BackToMenuCommand() {
        }

        @Override
        public void run() {
            Lobby.this.cardLayout.show(Lobby.this, Lobby.CARD_MENU);
        }
    }

    private class MainMenuPanel
    extends JPanel
    implements LobbyMode {
        public MainMenuPanel() {
            this.setOpaque(false);
            double[] columns = new double[]{-1.0, -2.0, -1.0};
            double[] rows = new double[]{-1.0, -2.0, -1.0};
            TableLayout layout = new TableLayout(columns, rows);
            this.setLayout(layout);
            JPanel buttonPanel = new JPanel(new GridLayout(0, 1, 0, 8));
            buttonPanel.setOpaque(false);
            MainMenuButton hostGame = new MainMenuButton("Host / Local game");
            MainMenuButton joinGame = new MainMenuButton(Lobby.CARD_JOIN_GAME);
            MainMenuButton options = new MainMenuButton(Lobby.CARD_OPTIONS);
            MainMenuButton levelEditor = new MainMenuButton("LevelEditor");
            MainMenuButton help = new MainMenuButton(Lobby.CARD_HELP);
            MainMenuButton credits = new MainMenuButton(Lobby.CARD_CREDITS);
            MainMenuButton quit = new MainMenuButton("Quit");
            buttonPanel.add(hostGame);
            buttonPanel.add(joinGame);
            buttonPanel.add(levelEditor);
            buttonPanel.add(help);
            buttonPanel.add(credits);
            buttonPanel.add(quit);
            hostGame.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Lobby.this.changeScreen(Lobby.CARD_HOST_GAME);
                }
            });
            joinGame.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Lobby.this.changeScreen(Lobby.CARD_JOIN_GAME);
                }
            });
            levelEditor.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Lobby.this.changeScreen(Lobby.CARD_LEVEL_EDITOR);
                }
            });
            help.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Lobby.this.changeScreen(Lobby.CARD_HELP);
                }
            });
            credits.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Lobby.this.changeScreen(Lobby.CARD_CREDITS);
                }
            });
            quit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Lobby.this.applicationFrame.quit();
                }
            });
            this.add((Component)buttonPanel, "1, 1, f, f");
            JLabel versionText = new JLabel("Ufohippa 3.0 released 2010-08-05");
            versionText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.add((Component)versionText, "1, 2, 2, 2, r, b");
        }

        @Override
        public void activate() {
        }
    }

    private class MainMenuButton
    extends JButton {
        public MainMenuButton(String text) {
            super(text);
            this.setFont(this.getFont().deriveFont((float)this.getFont().getSize() * 2.3f));
            this.setFocusable(false);
            this.setForeground(Color.darkGray);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension preferredSize = super.getPreferredSize();
            return new Dimension(Math.max(preferredSize.width, 250), preferredSize.height + 8);
        }
    }
}

