/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.lobby.gui;

import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import lonelycoders.ufohippa.client.ApplicationFrame;
import lonelycoders.ufohippa.client.levels.LevelManager;
import lonelycoders.ufohippa.client.lobby.gui.ColorPanel;
import lonelycoders.ufohippa.client.lobby.gui.LobbyMode;
import lonelycoders.ufohippa.game.level.LevelDescriptor;
import lonelycoders.ufohippa.game.level.Tile;
import lonelycoders.ufohippa.game.level.TileSet;
import lonelycoders.ufohippa.game.util.ColorRGB;
import lonelycoders.ufohippa.general.Logger;
import lonelycoders.ufohippa.leveleditor.LevelEditor;
import lonelycoders.ufohippa.util.ImageUtil;
import lonelycoders.ufohippa.util.XmlException;

public class LevelEditorPanel
extends JPanel
implements LobbyMode {
    private final LevelEditor levelEditor;
    private final LevelManager levelManager;
    private JToggleButton drawTilesButton;
    private ColorPanel colorChooser;

    public LevelEditorPanel(ApplicationFrame applicationFrame, Object gameLock, LevelManager levelManager, Runnable backCommand) {
        this.levelManager = levelManager;
        this.setOpaque(false);
        this.levelEditor = new LevelEditor();
        this.setLayout(new BorderLayout());
        MainToolBar toolBar = new MainToolBar(this.levelEditor, backCommand);
        toolBar.setOpaque(false);
        this.add((Component)toolBar, "North");
        EditingToolBar editingToolBar = new EditingToolBar(this.levelEditor);
        editingToolBar.setOpaque(false);
        this.add((Component)editingToolBar, "West");
        TileToolBar tileToolBar = new TileToolBar(this.levelEditor);
        tileToolBar.setOpaque(false);
        this.add((Component)tileToolBar, "East");
        this.add((Component)this.levelEditor.getComponent(), "Center");
    }

    @Override
    public void activate() {
        Logger.info("Activating level editor tab");
        this.levelEditor.setActive(true);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(new Color(255, 255, 255, 127));
        Rectangle clip = g.getClipBounds();
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
    }

    private class TileToolBar
    extends JToolBar {
        private final LevelEditor levelEditor;
        private final TileSetPanel tileSetPanel;

        public TileToolBar(final LevelEditor levelEditor) {
            super(1);
            this.levelEditor = levelEditor;
            levelEditor.addChangeListener(new LevelEditor.ChangeListener(){

                @Override
                public void tileChanged(Tile tile, boolean primary) {
                    TileToolBar.this.repaint();
                }

                @Override
                public void tileSetChanged(String tileSetName) {
                    TileToolBar.this.tileSetPanel.loadTileSet(levelEditor, tileSetName);
                }

                @Override
                public void tileColorChanged(ColorRGB color) {
                    if (color == null) {
                        color = ColorRGB.WHITE;
                    }
                    LevelEditorPanel.this.colorChooser.setColor(color);
                }
            });
            this.tileSetPanel = new TileSetPanel(levelEditor);
            double[] cols = new double[]{2.0, -2.0, 2.0};
            double[] rows = new double[]{2.0, -2.0, 2.0, -1.0};
            TableLayout tableLayout = new TableLayout(cols, rows);
            JPanel scrollView = new JPanel(tableLayout);
            scrollView.add((Component)this.tileSetPanel, "1, 1");
            JScrollPane tileSetScroll = new JScrollPane(scrollView, 22, 31);
            this.add(tileSetScroll);
            JPanel colorChooserPanel = new JPanel(new TableLayout(new double[]{2.0, -1.0, 2.0}, new double[]{2.0, -1.0, 2.0})){

                @Override
                public Dimension getMaximumSize() {
                    return new Dimension(super.getMaximumSize().width, 40);
                }

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, 40);
                }
            };
            colorChooserPanel.setBorder(BorderFactory.createEtchedBorder());
            LevelEditorPanel.this.colorChooser = new ColorPanel();
            colorChooserPanel.add((Component)LevelEditorPanel.this.colorChooser, "1, 1, f, f");
            LevelEditorPanel.this.colorChooser.addListener(new ColorPanel.Listener(){

                @Override
                public void colorChanged(ColorRGB newColor) {
                    levelEditor.setTileColor(newColor);
                }
            });
            LevelEditorPanel.this.colorChooser.setColor(ColorRGB.WHITE);
            this.add(colorChooserPanel);
        }

        private class TileSetPanel
        extends JPanel {
            private final LevelEditor levelEditor;
            private final int TILE_BORDER_SIZE = 2;
            private final int TILE_SIZE = 16;

            public TileSetPanel(LevelEditor levelEditor) {
                this.levelEditor = levelEditor;
                this.setLayout(new GridLayout(0, 4));
            }

            public void loadTileSet(LevelEditor levelEditor, String tileSetName) {
                this.removeAll();
                try {
                    TileSet tileSet = new TileSet(tileSetName);
                    for (Tile tile : tileSet.getAllTiles()) {
                        if (levelEditor.getSecondaryTile() == null) {
                            levelEditor.setSecondaryTile(tile);
                        }
                        this.add(new TilePanel(tile));
                    }
                }
                catch (XmlException e) {
                    Logger.exception(e);
                }
                catch (IOException e) {
                    Logger.exception(e);
                }
                this.invalidate();
                this.getParent().validate();
                this.repaint();
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension superPreferred = super.getPreferredSize();
                return new Dimension(72, superPreferred.height);
            }

            private class TilePanel
            extends JComponent {
                private final Image image;
                private final Tile tile;

                public TilePanel(final Tile tile) throws IOException {
                    this.tile = tile;
                    String imageName = tile.getImage2dName();
                    this.image = ImageUtil.loadImageResource(imageName);
                    this.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mousePressed(MouseEvent e) {
                            if (e.getButton() == 1) {
                                TileSetPanel.this.levelEditor.setPrimaryTile(tile);
                            } else if (e.getButton() == 3) {
                                TileSetPanel.this.levelEditor.setSecondaryTile(tile);
                            }
                            LevelEditorPanel.this.drawTilesButton.doClick();
                            TileToolBar.this.repaint();
                        }
                    });
                }

                @Override
                protected void paintComponent(Graphics g) {
                    Color active = null;
                    Tile primaryTile = TileSetPanel.this.levelEditor.getPrimaryTile();
                    Tile secondaryTile = TileSetPanel.this.levelEditor.getSecondaryTile();
                    if (primaryTile != null && primaryTile.equals(this.tile)) {
                        active = new Color(0, 0, 255);
                    } else if (secondaryTile != null && secondaryTile.equals(this.tile)) {
                        active = new Color(191, 0, 0);
                    }
                    if (active != null) {
                        g.setColor(active);
                        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                        g.setColor(Color.white);
                        g.drawRect(1, 1, this.getWidth() - 3, this.getHeight() - 3);
                    }
                    g.drawImage(this.image, 2, 2, this.getWidth() - 4, this.getHeight() - 4, null);
                }

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(18, 18);
                }
            }
        }
    }

    private class EditingToolBar
    extends JToolBar {
        public EditingToolBar(final LevelEditor levelEditor) {
            super(1);
            ButtonGroup group = new ButtonGroup();
            LevelEditorPanel.this.drawTilesButton = new JToggleButton(new AbstractAction("Draw"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    levelEditor.setTool(LevelEditor.Tool.DRAW);
                }
            });
            LevelEditorPanel.this.drawTilesButton.setOpaque(false);
            LevelEditorPanel.this.drawTilesButton.setToolTipText("Hint: Holding down CTRL key while clicking will pick the tile under cursor.");
            this.add(LevelEditorPanel.this.drawTilesButton);
            group.add(LevelEditorPanel.this.drawTilesButton);
            this.addSeparator();
            JToggleButton teleportNormalButton = new JToggleButton(new AbstractAction("Blue teleport"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    levelEditor.setTool(LevelEditor.Tool.TELEPORT_NORMAL);
                }
            });
            teleportNormalButton.setOpaque(false);
            this.add(teleportNormalButton);
            group.add(teleportNormalButton);
            JToggleButton teleportAnywhereButton = new JToggleButton(new AbstractAction("Red teleport"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    levelEditor.setTool(LevelEditor.Tool.TELEPORT_ANYWHERE);
                }
            });
            this.add(teleportAnywhereButton);
            group.add(teleportAnywhereButton);
            this.addSeparator();
            JToggleButton addColumnButton = new JToggleButton(new AbstractAction("Column++"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    levelEditor.setTool(LevelEditor.Tool.ADD_COLUMN);
                }
            });
            addColumnButton.setOpaque(false);
            this.add(addColumnButton);
            group.add(addColumnButton);
            JToggleButton removeColumnButton = new JToggleButton(new AbstractAction("Column--"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    levelEditor.setTool(LevelEditor.Tool.REMOVE_COLUMN);
                }
            });
            removeColumnButton.setOpaque(false);
            this.add(removeColumnButton);
            group.add(removeColumnButton);
            JToggleButton addRowButton = new JToggleButton(new AbstractAction("Row++"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    levelEditor.setTool(LevelEditor.Tool.ADD_ROW);
                }
            });
            addRowButton.setOpaque(false);
            this.add(addRowButton);
            group.add(addRowButton);
            JToggleButton removeRowButton = new JToggleButton(new AbstractAction("Row--"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    levelEditor.setTool(LevelEditor.Tool.REMOVE_ROW);
                }
            });
            removeRowButton.setOpaque(false);
            this.add(removeRowButton);
            group.add(removeRowButton);
            LevelEditorPanel.this.drawTilesButton.doClick();
        }
    }

    private class MainToolBar
    extends JToolBar {
        public MainToolBar(final LevelEditor levelEditor, final Runnable backCommand) {
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Ufohippa 3 levels", "level");
            final JFileChooser openChooser = new JFileChooser(LevelManager.createdLevelsPath);
            openChooser.setDialogTitle("Open level");
            openChooser.setFileFilter(filter);
            final JFileChooser saveChooser = new JFileChooser(LevelManager.createdLevelsPath);
            saveChooser.setDialogTitle("Save level");
            saveChooser.setFileFilter(filter);
            AbstractAction backButton = new AbstractAction("Back to menu"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    levelEditor.setActive(false);
                    backCommand.run();
                }
            };
            this.add(backButton).setOpaque(false);
            this.addSeparator();
            AbstractAction newButton = new AbstractAction("New"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String value = "new_tiles.xml";
                    if (value != null) {
                        String author = JOptionPane.showInputDialog(SwingUtilities.windowForComponent(LevelEditorPanel.this), "Enter name for level author.\nThis name is stored in the level file and is visible for other players.\nIt can be for example your real or nick name.", "Enter name", 3);
                        if (author == null) {
                            author = "Unknown";
                        }
                        levelEditor.newLevel(author, value);
                    }
                }
            };
            this.add(newButton).setOpaque(false);
            AbstractAction openButton = new AbstractAction("Open"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int returnValue = openChooser.showOpenDialog(SwingUtilities.windowForComponent(LevelEditorPanel.this));
                    if (returnValue == 0) {
                        File openPath = openChooser.getSelectedFile();
                        LevelDescriptor level = LevelManager.getLevel(openPath);
                        levelEditor.setLevel(openPath, level);
                    }
                }
            };
            this.add(openButton).setOpaque(false);
            AbstractAction saveButton = new AbstractAction("Save"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File levelPath = levelEditor.getLevelPath();
                    if (levelPath == null) {
                        int returnValue = saveChooser.showSaveDialog(SwingUtilities.windowForComponent(LevelEditorPanel.this));
                        if (returnValue == 0) {
                            File savePath = saveChooser.getSelectedFile();
                            if (!savePath.getName().endsWith(".level")) {
                                savePath = new File(savePath.getParent(), savePath.getName() + ".level");
                            }
                            levelEditor.saveLevel(savePath);
                            LevelEditorPanel.this.levelManager.refresh();
                        }
                    } else {
                        levelEditor.saveLevel(levelPath);
                    }
                }
            };
            this.add(saveButton).setOpaque(false);
            AbstractAction saveAsButton = new AbstractAction("Save as"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int returnValue = saveChooser.showSaveDialog(SwingUtilities.windowForComponent(LevelEditorPanel.this));
                    if (returnValue == 0) {
                        File savePath = saveChooser.getSelectedFile();
                        if (!savePath.getName().endsWith(".level")) {
                            savePath = new File(savePath.getParent(), savePath.getName() + ".level");
                        }
                        levelEditor.saveLevel(savePath);
                        LevelEditorPanel.this.levelManager.refresh();
                    }
                }
            };
            this.add(saveAsButton).setOpaque(false);
        }
    }
}

