/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.lobby.gui;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lonelycoders.ufohippa.client.lobby.gui.TitledPanel;
import lonelycoders.ufohippa.game.level.LevelDescriptor;
import lonelycoders.ufohippa.server.model.AllServerSettings;
import lonelycoders.ufohippa.server.model.PlayerInfo;

public class HostedGameSettingsPanel
extends TitledPanel {
    public HostedGameSettingsPanel(final AllServerSettings allServerSettings) {
        super("Round settings");
        this.setOpaque(false);
        this.setLayout(new TableLayout(new double[]{5.0, -2.0, -2.0, 5.0}, new double[]{0.0, -2.0, -2.0, -2.0, -2.0, -2.0, 5.0}));
        final JSpinner playerCount = new JSpinner(new SpinnerNumberModel(1, 1, 100, 1));
        final JSpinner playingTime = new JSpinner(new SpinnerNumberModel(1, 1, 100, 1));
        final JSpinner aiPlayers = new JSpinner();
        final JCheckBox bonusItems = new JCheckBox();
        final JCheckBox publicGame = new JCheckBox();
        final JCheckBox allowJoining = new JCheckBox();
        this.add((Component)new JLabel("Round time (minutes):"), "1, 1");
        this.add((Component)playingTime, "2, 1");
        this.add((Component)new JLabel("Computer players"), "1, 2");
        this.add((Component)aiPlayers, "2, 2");
        playerCount.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int value = (Integer)playerCount.getValue();
                allServerSettings.setBasicSettings(allServerSettings.getBasicSettings().newMaxPlayers(value));
            }
        });
        playingTime.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int value = (Integer)playingTime.getValue();
                allServerSettings.setBasicSettings(allServerSettings.getBasicSettings().newPlayingTime(value));
            }
        });
        aiPlayers.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int value = (Integer)aiPlayers.getValue();
                allServerSettings.setBasicSettings(allServerSettings.getBasicSettings().newNumberOfAIPlayers(value));
            }
        });
        bonusItems.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                allServerSettings.setBasicSettings(allServerSettings.getBasicSettings().newBonusItems(bonusItems.isSelected()));
            }
        });
        publicGame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                allServerSettings.setBasicSettings(allServerSettings.getBasicSettings().newPublicGame(publicGame.isSelected()));
            }
        });
        allowJoining.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                allServerSettings.setBasicSettings(allServerSettings.getBasicSettings().newAllowJoiningDuringGame(allowJoining.isSelected()));
            }
        });
        allServerSettings.addListener(new AllServerSettings.Listener(){

            @Override
            public void basicSettingsChanged(int newMaxPlayers, int newPlayingTime, int newAiPlayers, boolean newBonusItems, boolean newPublicGame, boolean newAllowJoiningDuringGame) {
                playerCount.setValue(newMaxPlayers);
                playingTime.setValue(newPlayingTime);
                aiPlayers.setValue(newAiPlayers);
                bonusItems.setSelected(newBonusItems);
                publicGame.setSelected(newPublicGame);
                allowJoining.setSelected(newAllowJoiningDuringGame);
            }

            @Override
            public void levelsChanged(List<LevelDescriptor> levels) {
            }

            @Override
            public void playersChanged(List<PlayerInfo> players) {
            }
        });
    }
}

