/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.gl.texturing;

import com.sun.opengl.util.BufferUtil;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import lonelycoders.ufohippa.client.gl.texturing.Texture;
import lonelycoders.ufohippa.general.Logger;
import lonelycoders.ufohippa.util.ImageUtil;

public class ImageTexture
extends Texture {
    private final TextureLoader loader;
    private TextureInfo textureInfo;

    private ImageTexture(TextureLoader loader) {
        super(Texture.Type.TYPE_2D);
        this.loader = loader;
    }

    public ImageTexture(final int width, final int height, final Format format, final Buffer pixels) {
        this(new TextureLoader(){

            @Override
            public TextureInfo load() {
                return new TextureInfo(width, height, format, pixels);
            }
        });
    }

    public ImageTexture(final int width, final int height, final Format format, final int[] data) {
        this(new TextureLoader(){

            @Override
            public TextureInfo load() {
                IntBuffer pixels = BufferUtil.newIntBuffer(data.length);
                pixels.put(data);
                pixels.flip();
                return new TextureInfo(width, height, format, pixels);
            }
        });
    }

    public ImageTexture(final BufferedImage image) {
        this(new TextureLoader(){

            @Override
            public TextureInfo load() {
                return new TextureInfo(image);
            }
        });
    }

    public ImageTexture(final ImageGenerator generator) {
        this(new TextureLoader(){

            @Override
            public TextureInfo load() {
                return new TextureInfo(generator.getWidth(), generator.getHeight(), generator.getFormat(), generator.getPixels());
            }
        });
    }

    public ImageTexture(final String resourceName) {
        this(new TextureLoader(){

            @Override
            public TextureInfo load() {
                try {
                    return new TextureInfo(ImageUtil.loadImageResource(resourceName));
                }
                catch (IOException e) {
                    Logger.exception(e);
                    return null;
                }
            }
        });
    }

    @Override
    public void load() {
        this.textureInfo = this.loader.load();
    }

    @Override
    public void loadGl(GL gl) {
        super.loadGl(gl);
        gl.glBindTexture(3553, this.id);
        new GLU().gluBuild2DMipmaps(3553, 32849, this.textureInfo.width, this.textureInfo.height, this.textureInfo.format.glFormat, 5121, this.textureInfo.pixels);
        gl.glTexParameteri(3553, 10241, 9729);
        gl.glTexParameteri(3553, 10240, 9729);
    }

    private static interface TextureLoader {
        public TextureInfo load();
    }

    private static class TextureInfo {
        private final int width;
        private final int height;
        private final Format format;
        private final Buffer pixels;

        private TextureInfo(int width, int height, Format format, Buffer pixels) {
            this.width = width;
            this.height = height;
            this.format = format;
            this.pixels = pixels;
        }

        public TextureInfo(BufferedImage image) {
            this.width = image.getWidth();
            this.height = image.getHeight();
            int[] argb = new int[this.width * this.height];
            image.getRGB(0, 0, this.width, this.height, argb, 0, this.width);
            ByteBuffer pixels = BufferUtil.newByteBuffer(this.width * this.height * 4);
            for (int y = 0; y < this.height; ++y) {
                int offset = (this.height - 1 - y) * this.width;
                int x = 0;
                while (x < this.width) {
                    pixels.put((byte)(argb[offset] >> 16));
                    pixels.put((byte)(argb[offset] >> 8));
                    pixels.put((byte)argb[offset]);
                    pixels.put((byte)(argb[offset] >> 24));
                    ++x;
                    ++offset;
                }
            }
            pixels.flip();
            this.pixels = pixels;
            this.format = Format.RGBA;
        }
    }

    public static enum Format {
        RGB(6407),
        RGBA(6408),
        GRAYSCALE(6409),
        ALPHA(6406);

        private final int glFormat;

        private Format(int glFormat) {
            this.glFormat = glFormat;
        }
    }

    public static interface ImageGenerator {
        public int getWidth();

        public int getHeight();

        public Format getFormat();

        public Buffer getPixels();
    }
}

