/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.gl.texturing;

import com.sun.opengl.util.BufferUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import lonelycoders.ufohippa.client.gl.texturing.ImageTexture;

public class CircleTexture
extends ImageTexture {
    public CircleTexture(final int size) {
        super(new ImageTexture.ImageGenerator(){

            @Override
            public int getWidth() {
                return size;
            }

            @Override
            public int getHeight() {
                return size;
            }

            @Override
            public ImageTexture.Format getFormat() {
                return ImageTexture.Format.GRAYSCALE;
            }

            @Override
            public Buffer getPixels() {
                ByteBuffer pixels = BufferUtil.newByteBuffer(size * size);
                double radius = (double)(size - 1) / 2.0;
                for (int y = 0; y < size; ++y) {
                    for (int x = 0; x < size; ++x) {
                        double x2 = ((double)x - radius) / radius / Math.sqrt(2.0);
                        double y2 = ((double)y - radius) / radius / Math.sqrt(2.0);
                        double alpha = Math.sqrt(x2 * x2 + y2 * y2);
                        pixels.put((byte)(alpha * 256.0));
                    }
                }
                pixels.flip();
                return pixels;
            }
        });
    }
}

