/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.gl;

import com.sun.opengl.util.BufferUtil;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.LinkedHashMap;
import javax.media.opengl.GL;
import lonelycoders.ufohippa.client.gl.Mesh;
import lonelycoders.ufohippa.client.gl.Triangle;
import lonelycoders.ufohippa.client.gl.Vertex;
import lonelycoders.ufohippa.client.resource.ResourceGL;
import lonelycoders.ufohippa.game.util.Vector2;
import lonelycoders.ufohippa.game.util.Vector3;
import org.jetbrains.annotations.NotNull;

public class MeshGL
implements ResourceGL {
    private final Mesh mesh;
    private final RenderType renderType;
    private int displayListId;
    private ShortBuffer indices;
    private FloatBuffer vertices;
    private FloatBuffer texCoords;
    private FloatBuffer normals;
    private int indexCount;
    private int vertexCount;
    private int VBOIndices;
    private int VBOVertices;
    private int VBOTexCoords;
    private int VBONormals;

    public MeshGL(Mesh mesh, RenderType renderType) {
        this.renderType = renderType;
        this.mesh = mesh;
    }

    @Override
    public void load() {
        switch (this.renderType) {
            case DIRECT: {
                break;
            }
            case VERTEX_ARRAY: {
                this.createBuffers(this.mesh);
                break;
            }
            case VERTEX_BUFFER: {
                this.createBuffers(this.mesh);
            }
        }
    }

    @Override
    public void loadGl(GL gl) {
        switch (this.renderType) {
            case DISPLAY_LIST: {
                this.displayListId = gl.glGenLists(1);
                gl.glNewList(this.displayListId, 4864);
                this.renderDirect(gl, this.mesh);
                gl.glEndList();
                break;
            }
            case VERTEX_BUFFER: {
                this.buildVBOs(gl);
            }
        }
    }

    private void createBuffers(Mesh mesh) {
        Triangle[] triangles = mesh.getTriangles();
        this.indexCount = triangles.length * 3;
        this.indices = BufferUtil.newShortBuffer(this.indexCount);
        int index = 0;
        LinkedHashMap<VertexInfo, Short> vertexMap = new LinkedHashMap<VertexInfo, Short>();
        for (Triangle triangle : triangles) {
            Vector3 faceNormal = triangle.getNormal();
            for (Vertex vertex : triangle.getVertices()) {
                Vector3 normal;
                Vector3 vertexNormal = vertex.getNormal();
                Vector3 vector3 = normal = vertexNormal != null ? vertexNormal : faceNormal;
                assert (normal != null);
                VertexInfo key = new VertexInfo(vertex.getPosition(), vertex.getTextureCoordinates(), normal);
                if (!vertexMap.containsKey(key)) {
                    vertexMap.put(key, (short)index++);
                }
                this.indices.put((Short)vertexMap.get(key));
            }
        }
        this.vertexCount = index;
        this.indices.flip();
        this.vertices = BufferUtil.newFloatBuffer(this.vertexCount * 3);
        this.texCoords = BufferUtil.newFloatBuffer(this.vertexCount * 3);
        this.normals = BufferUtil.newFloatBuffer(this.vertexCount * 3);
        for (VertexInfo vertexInfo : vertexMap.keySet()) {
            Vector3 position = vertexInfo.getPosition();
            Vector2 textureCoordinates = vertexInfo.getTextureCoordinates();
            Vector3 normal = vertexInfo.getNormal();
            this.vertices.put(position.x);
            this.vertices.put(position.y);
            this.vertices.put(position.z);
            this.texCoords.put(textureCoordinates.x);
            this.texCoords.put(textureCoordinates.y);
            this.normals.put(normal.x);
            this.normals.put(normal.y);
            this.normals.put(normal.z);
        }
        this.vertices.flip();
        this.texCoords.flip();
        this.normals.flip();
    }

    private void buildVBOs(GL gl) {
        int[] temp = new int[4];
        gl.glGenBuffers(4, temp, 0);
        int id = 0;
        this.VBOVertices = temp[id++];
        gl.glBindBuffer(34962, this.VBOVertices);
        gl.glBufferData(34962, this.vertexCount * 3 * 4, this.vertices, 35044);
        gl.glBindBuffer(34962, 0);
        this.VBOTexCoords = temp[id++];
        gl.glBindBuffer(34962, this.VBOTexCoords);
        gl.glBufferData(34962, this.vertexCount * 2 * 4, this.texCoords, 35044);
        gl.glBindBuffer(34962, 0);
        this.VBONormals = temp[id++];
        gl.glBindBuffer(34962, this.VBONormals);
        gl.glBufferData(34962, this.vertexCount * 3 * 4, this.normals, 35044);
        gl.glBindBuffer(34962, 0);
        this.VBOIndices = temp[id];
        gl.glBindBuffer(34963, this.VBOIndices);
        gl.glBufferData(34963, this.indexCount * 2, this.indices, 35044);
        gl.glBindBuffer(34963, 0);
        this.vertices = null;
        this.texCoords = null;
        this.normals = null;
        this.indices = null;
    }

    private void destroyVBOs(GL gl) {
        int[] buffers = new int[]{this.VBOVertices, this.VBOTexCoords, this.VBONormals, this.VBOIndices};
        gl.glDeleteBuffers(3, buffers, 0);
    }

    public void render(GL gl) {
        switch (this.renderType) {
            case DIRECT: {
                this.renderDirect(gl, this.mesh);
                break;
            }
            case DISPLAY_LIST: {
                gl.glCallList(this.displayListId);
                break;
            }
            case VERTEX_ARRAY: {
                gl.glEnableClientState(32884);
                gl.glEnableClientState(32888);
                gl.glEnableClientState(32885);
                gl.glVertexPointer(3, 5126, 0, this.vertices);
                gl.glTexCoordPointer(2, 5126, 0, this.texCoords);
                gl.glNormalPointer(5126, 0, this.normals);
                gl.glDrawElements(4, this.indexCount, 5123, this.indices);
                gl.glDisableClientState(32885);
                gl.glDisableClientState(32888);
                gl.glDisableClientState(32884);
                break;
            }
            case VERTEX_BUFFER: {
                gl.glEnableClientState(32884);
                gl.glEnableClientState(32888);
                gl.glEnableClientState(32885);
                gl.glBindBuffer(34962, this.VBOVertices);
                gl.glVertexPointer(3, 5126, 0, 0L);
                gl.glBindBuffer(34962, this.VBOTexCoords);
                gl.glTexCoordPointer(2, 5126, 0, 0L);
                gl.glBindBuffer(34962, this.VBONormals);
                gl.glNormalPointer(5126, 0, 0L);
                gl.glBindBuffer(34963, this.VBOIndices);
                gl.glDrawElements(4, this.indexCount, 5123, 0L);
                gl.glBindBuffer(34962, 0);
                gl.glBindBuffer(34963, 0);
                gl.glDisableClientState(32885);
                gl.glDisableClientState(32888);
                gl.glDisableClientState(32884);
            }
        }
    }

    private void renderDirect(GL gl, Mesh mesh) {
        Triangle[] triangles;
        for (Triangle triangle : triangles = mesh.getTriangles()) {
            gl.glBegin(4);
            Vector3 normal = triangle.getNormal();
            if (normal != null) {
                gl.glNormal3fv(normal.toFloatArray(), 0);
            }
            for (Vertex vertex : triangle.getVertices()) {
                normal = vertex.getNormal();
                if (normal != null) {
                    gl.glNormal3fv(normal.toFloatArray(), 0);
                }
                gl.glVertex3fv(vertex.getPosition().toFloatArray(), 0);
            }
            gl.glEnd();
        }
    }

    public static enum RenderType {
        DIRECT,
        DISPLAY_LIST,
        VERTEX_ARRAY,
        VERTEX_BUFFER;

    }

    private static class VertexInfo {
        @NotNull
        private final Vector3 position;
        @NotNull
        private final Vector2 textureCoordinates;
        @NotNull
        private final Vector3 normal;

        private VertexInfo(Vector3 position, Vector2 textureCoordinates, Vector3 normal) {
            this.position = position;
            this.textureCoordinates = textureCoordinates;
            this.normal = normal;
        }

        @NotNull
        public Vector3 getPosition() {
            return this.position;
        }

        @NotNull
        public Vector2 getTextureCoordinates() {
            return this.textureCoordinates;
        }

        @NotNull
        public Vector3 getNormal() {
            return this.normal;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VertexInfo that = (VertexInfo)o;
            return this.position.equals(that.position) && this.textureCoordinates.equals(that.textureCoordinates) && this.normal.equals(that.normal);
        }

        public int hashCode() {
            int result = this.position.hashCode();
            result = 31 * result + this.textureCoordinates.hashCode();
            result = 31 * result + this.normal.hashCode();
            return result;
        }
    }
}

