/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import lonelycoders.ufohippa.client.ApplicationFrame;
import lonelycoders.ufohippa.client.Client;
import lonelycoders.ufohippa.client.Main;
import lonelycoders.ufohippa.client.levels.LevelManager;
import lonelycoders.ufohippa.client.sound.SoundManagerImpl;
import lonelycoders.ufohippa.client.states.ClientLobbyState;
import lonelycoders.ufohippa.game.level.LevelDescriptor;
import lonelycoders.ufohippa.game.util.ColorRGB;
import lonelycoders.ufohippa.general.Logger;
import lonelycoders.ufohippa.network.NetworkProtocolException;
import lonelycoders.ufohippa.server.Server;

public class MainDirect {
    private static final Object GAME_LOCK = "GAME_LOCK";

    public static void main(String[] args) {
        Main.parseCommandLine(args);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException e) {
            Logger.exception(e);
        }
        catch (InstantiationException e) {
            Logger.exception(e);
        }
        catch (IllegalAccessException e) {
            Logger.exception(e);
        }
        catch (UnsupportedLookAndFeelException e) {
            Logger.exception(e);
        }
        Server server = new Server();
        server.start();
        SoundManagerImpl soundManager = new SoundManagerImpl();
        LevelManager levelManager = new LevelManager();
        Client client = new Client(soundManager, levelManager, "GUI client", GAME_LOCK, new Client.Listener(){

            @Override
            public void clientDisconnected(NetworkProtocolException e) {
                Logger.info("Client was disconnected");
            }
        });
        ApplicationFrame mainFrame = new ApplicationFrame(GAME_LOCK);
        mainFrame.registerClient(client);
        try {
            client.connect(InetAddress.getLocalHost(), 13579);
        }
        catch (IOException e) {
            Logger.exception(e);
        }
        ClientLobbyState lobbyState = client.getManager().getLobbyState();
        lobbyState.setClientSettings(1, new String[]{"Player 1", "Player 2"}, new ColorRGB[]{ColorRGB.RED, ColorRGB.BLUE});
        ArrayList<? extends LevelDescriptor> levels = new ArrayList<LevelDescriptor>(levelManager.getAllLevels());
        Collections.shuffle(levels);
        for (int i = 0; i < 5; ++i) {
            server.getAllServerSettings().addLevel((LevelDescriptor)levels.get(i));
        }
        server.getAllServerSettings().setBasicSettings(server.getAllServerSettings().getBasicSettings().newPlayingTime(1));
        server.getAllServerSettings().setBasicSettings(server.getAllServerSettings().getBasicSettings().newNumberOfAIPlayers(3));
        client.waitForReady();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            Logger.exception(e);
        }
        server.startGame();
    }
}

