/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client;

import java.io.File;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import lonelycoders.ufohippa.client.ApplicationFrame;
import lonelycoders.ufohippa.client.GlobalConfigs;
import lonelycoders.ufohippa.general.Logger;
import lonelycoders.ufohippa.general.logger.FileLoggerHandler;

public class Main {
    private static final Object gameLock = "GAME_LOCK";

    public static void main(String[] args) {
        Main.parseCommandLine(args);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException e) {
            Logger.exception(e);
        }
        catch (InstantiationException e) {
            Logger.exception(e);
        }
        catch (IllegalAccessException e) {
            Logger.exception(e);
        }
        catch (UnsupportedLookAndFeelException e) {
            Logger.exception(e);
        }
        ApplicationFrame mainFrame = new ApplicationFrame(gameLock);
        mainFrame.setMenuActive(true);
    }

    public static void parseCommandLine(String[] args) {
        int i = 0;
        while (i < args.length) {
            String arg;
            if ((arg = args[i++]).equalsIgnoreCase("/?")) {
                Main.printUsage(0);
                continue;
            }
            if (arg.equalsIgnoreCase("/log")) {
                if (args.length < i + 2) {
                    Main.printUsage(1);
                }
                File logFile = new File(args[i++]);
                String logTolerance = args[i++];
                Logger.Level tolerance = null;
                if (logTolerance.equalsIgnoreCase("basic")) {
                    tolerance = Logger.Level.WARNING;
                } else if (logTolerance.equalsIgnoreCase("info")) {
                    tolerance = Logger.Level.INFO;
                } else if (logTolerance.equalsIgnoreCase("detail")) {
                    tolerance = Logger.Level.DETAIL;
                } else {
                    Main.printUsage(1);
                }
                Logger.registerLogger(new FileLoggerHandler(logFile), tolerance);
                continue;
            }
            if (arg.equalsIgnoreCase("/nosound")) {
                GlobalConfigs.setSoundsEnabled(false);
                continue;
            }
            if (arg.equalsIgnoreCase("/720p")) {
                GlobalConfigs.set720p(true);
                continue;
            }
            if (arg.equalsIgnoreCase("/fullscreen")) {
                GlobalConfigs.setFullscreen(true);
                continue;
            }
            Main.printUsage(1);
        }
    }

    private static void printUsage(int errorLevel) {
        System.out.println("Usage:\tjava -jar Ufohippa3.jar [/?] [/log <filename> <basic|info>] [/nosound] [/fullscreen]");
        System.exit(errorLevel);
    }
}

