require('GFXConstants')
require('utils')
--require('Tween')
require('Events')
require('_events_list')
require('Effect')
require('EffectSequencer')
require('EffectCleanPlain')
require('EffectFlash')
require('EffectMetronomic')
require('EffectPolka')
require('EffectSceneAbstract')
require('EffectScenePolygons')
require('EffectSceneAbstractAnother')
require('EffectPulsing')
require('EffectSceneAbstractMore')

-- Assets
Assets = {}

function setup()
	trace("setup")
	Assets.musicStream = loadMusicStream('r08028_restart.ogg')
	
	math.randomseed(1)
	
	-- Effects
	effect_clean = EffectCleanPlain:new()
	--effect_clean.b = 1
	EffectSequencer.add(effect_clean, { start_order = 0, start_row = 0, end_order = 100, end_row = 0, label = 'cleaner' })
	
	effect_flash = EffectFlash:new()
	EventDispatcher.addEventListener(effect_flash, EVENT_NOTE_ON)
	EffectSequencer.add(effect_flash, { start_order = 0, start_row = 0, end_order = 100, end_row = 0, label = 'hat-flash' })
	
	
	effect_metro = EffectMetronomic:new()
	effect_metro.r = 1
	effect_metro.g = 1
	effect_metro.b = 1
	EventDispatcher.addEventListener(effect_metro, EVENT_NOTE_ON)
	EffectSequencer.add(effect_metro, { start_order = 0, start_row = 0, end_order = 37, end_row = 0, label = 'metronomic' })
	
	
	effect_polka = EffectPolka:new()
	effect_polka.r = 0.6
	effect_polka.g = 0.6
	effect_polka.b = 0.8
	EventDispatcher.addEventListener(effect_polka, EVENT_NOTE_ON)
	EffectSequencer.add(effect_polka, { start_order = 2, start_row = 0, end_order = 8, end_row = 0, label = 'polka' })
	
	
	effect = EffectSceneAbstract:new()
	EventDispatcher.addEventListener(effect, EVENT_NOTE_ON)
	EventDispatcher.addEventListener(effect, EVENT_CHANGE_ROW)
	EventDispatcher.addEventListener(effect, EVENT_CHANGE_ORDER)
	EffectSequencer.add(effect, { start_order = 6, start_row = 0, end_order = 10, end_row = 0, label = 'abstract' })
	
	
	effect = EffectScenePolygons:new()
	EventDispatcher.addEventListener(effect, EVENT_NOTE_ON)
	EffectSequencer.add(effect, { start_order = 8, start_row = 0, end_order = 16, end_row = 0, label = 'polygons' })
	
	
	effect = EffectSceneAbstractAnother:new()
	EventDispatcher.addEventListener(effect, EVENT_NOTE_ON)
	EventDispatcher.addEventListener(effect, EVENT_CHANGE_ROW)
	EventDispatcher.addEventListener(effect, EVENT_CHANGE_ORDER)
	EffectSequencer.add(effect, { start_order = 10, start_row = 0, end_order = 16, end_row = 0, label = 'abstract_another' })
	
	
	effect = EffectPulsing:new()
	EventDispatcher.addEventListener(effect, EVENT_NOTE_ON)
	EventDispatcher.addEventListener(effect, EVENT_CHANGE_ROW)
	EffectSequencer.add(effect, { start_order = 16, start_row = 0, end_order = 43, end_row = 0, label = 'pulsing' })
	
	
	effect = EffectSceneAbstractMore:new()
	effect.r = 0
	effect.g = 1
	effect.b = 1
	EventDispatcher.addEventListener(effect, EVENT_NOTE_ON)
	EventDispatcher.addEventListener(effect, EVENT_CHANGE_ROW)
	EffectSequencer.add(effect, { start_order = 43, start_row = 0, end_order = 100, end_row = 0, label = 'abstract2' })
	
	EffectSequencer.setupEffects()
	EffectSequencer.dump()
	
	-- Events
	EventDispatcher.addEventListener(EffectSequencer, EVENT_CHANGE_ORDER)
	EventDispatcher.addEventListener(EffectSequencer, EVENT_CHANGE_ROW)
	
	-----

	img_xplsv = loadImage('txt_xplsv.png')
	img_totally = loadImage('txt_02_totally.png')
	img_yay = loadImage('txt_03_yay.png')
	img_greetings = loadImage('txt_04_greetings.png')
	
	setupIsDone()
	playMusicStream(Assets.musicStream, getMusicStartPosition())
end


function draw(ticks)
	program_seconds = ticks * 0.001
	song_seconds = getMusicStreamTime(Assets.musicStream)
	windowTitle('p:' .. program_seconds .. ' s: ' .. song_seconds)
	
	-- Processes events
	finished = EventDispatcher.update(song_seconds)
	if finished then
		quit()
	end
	
	-- V important too, sadly unfinished
	-- TweenManager.update(song_seconds)
	
	-- Draw!
	EffectSequencer.update(song_seconds)
	
	--[[ortho(4, 3)
	
	--background(1, 0, 0, 1)
	color(1, 1, 1, 0.51)
	
	blending(BLENDING_ALPHABLEND)
	
	beginShape(SHAPE_QUADS)
	
	vertex(0, 0, 0)
	vertex(1, 0, 0)
	vertex(1, 1, 0)
	vertex(0, 1, 0)
	
	endShape()
	
	color(1, 1, 0, 0.9)
	
	beginShape(SHAPE_LINES)
	vertex(-1, -1, 0)
	vertex(1, 1, 0)
	
	vertex(-1, 1, 0)
	vertex(1, -1, 0)
	endShape()
	
	
	noBlending()
	
	restoreProjection()]]--
end
