#include <stdio.h>
#include <stdlib.h>
#include <pango/pangocairo.h>

typedef struct {
    unsigned char* idata;
    int width;
    int height;
    int stride;
} image_t;

void pangotext(PangoLayout *layout, const char* txt, const char* font); 
void rendertext(cairo_t *cr, const char* txt, const char* font);
void get_pixel_size(const char* txt, const char* font, int *w, int *h);
image_t* create_text_image(const char* txt, const char* font);
void destroy_text_image(image_t *img);


