{-# OPTIONS_GHC -optc-D_REENTRANT #-}
{-# INCLUDE "texture_generate.h" #-}
{-# LINE 1 "TextGen.hsc" #-}
{-# LANGUAGE ForeignFunctionInterface #-}
{-# LINE 2 "TextGen.hsc" #-}

module TextGen where

import Foreign
import Foreign.C


{-# LINE 9 "TextGen.hsc" #-}



data Image = Image { idata::Ptr CUChar, width::CInt, height::CInt, stride::CInt }

instance Storable Image where
  alignment _ = alignment(undefined :: Ptr ())
  sizeOf _ = (24)
{-# LINE 17 "TextGen.hsc" #-}
  peek ptr = do
    idata <- (\hsc_ptr -> peekByteOff hsc_ptr 0) ptr
{-# LINE 19 "TextGen.hsc" #-}
    width <- (\hsc_ptr -> peekByteOff hsc_ptr 8) ptr
{-# LINE 20 "TextGen.hsc" #-}
    height <- (\hsc_ptr -> peekByteOff hsc_ptr 12) ptr
{-# LINE 21 "TextGen.hsc" #-}
    stride <- (\hsc_ptr -> peekByteOff hsc_ptr 16) ptr
{-# LINE 22 "TextGen.hsc" #-}
    return (Image idata width height stride)
  poke ptr (Image idata width height stride) = do
    (\hsc_ptr -> pokeByteOff hsc_ptr 0) ptr idata
{-# LINE 25 "TextGen.hsc" #-}
    (\hsc_ptr -> pokeByteOff hsc_ptr 8) ptr width
{-# LINE 26 "TextGen.hsc" #-}
    (\hsc_ptr -> pokeByteOff hsc_ptr 12) ptr height
{-# LINE 27 "TextGen.hsc" #-}
    (\hsc_ptr -> pokeByteOff hsc_ptr 16) ptr stride
{-# LINE 28 "TextGen.hsc" #-}

foreign import ccall "texture_generate.h create_text_image" createTextImage :: 
    CString -> CString -> IO (Ptr Image)


