module SceneBlock2 (b2_rawscenes) where

import Util

left = (-3)
right = 3
down = (-3)
up = 3

b2_tm1 = 7000
b2_tm2 = 12100
b2_tm3 = 16000
b2_tm4 = 21000
bf = 800

-------------------------------------------------------------------------------
-- Block 2: Teaser: dates & stuff

-- Date & year
yr_h = 0.2
b2_t1a_path = Path (TP (pnt left yr_h) (b2_tm1-300)) (TP (pnt (-0.2) yr_h) b2_tm1) (TP (pnt (0.2) yr_h) (b2_tm2-bf)) (TP (pnt right yr_h) (b2_tm2-bf+300))
b2_t1a = LoadMarquee "2010" 1.5 b2_t1a_path
dt_h = (-0.2)
b2_t1b_path = Path (TP (pnt right dt_h) (b2_tm1-300)) (TP (pnt (0.05) dt_h) b2_tm1) (TP (pnt (-0.05) dt_h) (b2_tm2-bf)) (TP (pnt left dt_h) (b2_tm2-bf+300))
b2_t1b = LoadMarquee "5.-7.11." 0.6 b2_t1b_path

-- Jkl & FIN
jyv_h = 0.1
b2_t2a_path = Path (TP (pnt left jyv_h) (b2_tm2-300)) (TP (pnt 0 jyv_h) b2_tm2) (TP (pnt 0 jyv_h) (b2_tm3-bf)) (TP (pnt right jyv_h) (b2_tm3-bf+300))
b2_t2a = LoadMarquee "Jyväskylä" 1.5 b2_t2a_path

fin_w = (-0.5)
fin_h = (-0.2)
b2_t2b_path = Path (TP (pnt fin_w down) (b2_tm2-300)) (TP (pnt fin_w fin_h) b2_tm2) (TP (pnt fin_w fin_h) (b2_tm3-bf)) (TP (pnt fin_w up) (b2_tm3-bf+300))
b2_t2b = LoadMarquee "ILOKIVI" 0.4 b2_t2b_path

-- Havaintoesityshipat & eli demopartyt / TODO: kuvat
havainto_h = 0.2
b2_t3a_path = Path (TP (pnt left havainto_h) (b2_tm3-300)) (TP (pnt (-0.1) havainto_h) b2_tm3) (TP (pnt 0.1 havainto_h) (b2_tm4-bf)) (TP (pnt right havainto_h) (b2_tm4-bf+300))
b2_t3a = LoadMarquee "Havaintoesityshipat" 1.2 b2_t3a_path
demo_h = (-0.3)
b2_t3b_path = Path (TP (pnt right demo_h) (b2_tm3-300)) (TP (pnt (0.2) demo_h) b2_tm3) (TP (pnt (-0.2) demo_h) (b2_tm4-bf)) (TP (pnt left demo_h) (b2_tm4-bf+300))
b2_t3b = LoadMarquee "DEMOPARTY" 1.5 b2_t3b_path

b2_rawscenes :: [RawScene]
b2_rawscenes = [b2_t1a, b2_t1b, b2_t2b, b2_t2a, b2_t3a, b2_t3b]

