module Main where

import Graphics.GPipe
import Graphics.GPipe.Texture.Load
import Graphics.UI.GLUT (Window, mainLoop, postRedisplay, idleCallback, getArgsAndInitialize, fullScreen, ($=))
import Graphics.UI.GLUT.Window (Cursor(None), cursor)
import Graphics.UI.GLUT.Callbacks (Key(Char),keyboardMouseCallback)
import System.Exit (exitWith, ExitCode(ExitSuccess))
import Data.IORef
import Control.Monad.State
import Textures
import Env
import Display
import Util
import SceneBlock1 (b1_rawscenes)
import SceneBlock2 (b2_rawscenes)
import SceneBlock3 (b3_rawscenes)
import SceneBlock4 (b4_rawscenes)
import SceneBlock5 (b5_rawscenes)
import SceneBlock6 (b6_rawscenes)

rawscenes = concat [b1_rawscenes, b2_rawscenes, b3_rawscenes, b4_rawscenes, b5_rawscenes, b6_rawscenes]

main :: IO ()
main = do
    getArgsAndInitialize
    env <- initEnv
    putStrLn "Creating window..."

    readyScenes <- mapM load rawscenes

    newWindow "Instanssi Invtro"
        (100:.100:.())
        (1280:.720:.())
        (paskanJohdatin env readyScenes)
        initWindow
    fullScreen
    cursor $= None -- Hides mouse pointer.
    keyboardMouseCallback $= (Just escExiter)
    putStrLn "Entering mainloop..."
    mainLoop

paskanJohdatin :: Env -> [Scene] -> Vec2 Int -> IO (FrameBuffer RGBAFormat () ())
paskanJohdatin env scenes size = do
    updateEnv env
    frameinfo <- readIORef env
    return $ renderFrame size (time frameinfo) $ scenes

initWindow :: Window -> IO ()
initWindow win = idleCallback $= Just (postRedisplay (Just win))

-- |Doesn't exit the friendly way, but seems to work.
escExiter (Char '\ESC') _ _ _ = do
  putStrLn "ESC pressed, exiting..."
  exitWith ExitSuccess
escExiter _ _ _ _ = return ()
