module LameShuffle where

import System.Random (StdGen,randoms)
import Data.List (sort)

-- |Shuffles list of values. Not statistically perfect but works.
shuffle :: (Ord a) => StdGen -> [a] -> [a]
shuffle gen xs = randSorter xs
    where order = (randoms gen) :: [Int]
          randSorter xs = map snd $ sort $ (zip order xs)
