module Env where

import Graphics.UI.GLUT (elapsedTime)
import Graphics.GPipe
import Data.IORef
import Data.StateVar

type Time = Float
type Frame = Int
type Env = IORef (Time, Frame)

initEnv :: IO Env
initEnv = newIORef (0, 0)

skip = 0 -- skip in millis

updateEnv :: Env -> IO ()
updateEnv env = do
    values <- readIORef env
    millis <- (get elapsedTime) -- Using GLUT elapsedTime to figure millis count.
    writeIORef env $ (\(time, frame) -> ((fromIntegral millis)+skip, frame + 1)) values

time :: (Time, Frame) -> Time
time env = fst env
