
import Image

def init(width, height):
    global WIDTH, HEIGHT
    print "Init function executed."
    img = Image.open('../data/testimage.png')
    print "Image: ", img
    data = img.getdata()
    print "Image data size: ", len(data)
    WIDTH = width
    HEIGHT = height

def clamp(x):
    return max(min(x, 1), 0)

def pixel(r, g, b, a):
    return chr(int(clamp(r)*255.))+chr(int(clamp(g)*255.))+chr(int(clamp(b)*255.))+chr(int(clamp(a)*255.))

def render(time_in_micros):
    print "In render function, time: " + str(time_in_micros)
    
    buf = []
    for y in xrange(HEIGHT):
        for x in xrange(WIDTH):
            buf.append(pixel(x*1./WIDTH,
                             y*1./HEIGHT,
                             (int(time_in_micros)%1000000)/100000.,
                             1))
    return ''.join(buf)

