#!/usr/bin/python

import sys
import struct

width = int(sys.argv[1])
height = int(sys.argv[2])

sys.stderr.write("test.py: args %d %d\n" % (width, height))

while (True):
    time_bin = sys.stdin.read(4)
    # See if input closed
    if len(time_bin) == 0:
        sys.stderr.write('Received EOF from input\n')
        break;
    
    time = struct.unpack('=I', time_bin)[0]
    timemod = int((time % 1000) * 0.255)

    pixel_out = struct.pack('cccc', chr(timemod), chr(timemod), chr(timemod), chr(255))
    sys.stdout.write(pixel_out * width * height)
    
