function init(w, h)
   width = w
   height = h

   centerx = w / 2
   centery = h / 2
   range = math.min(width, height) / 2 * 0.7

   angledelta = 4 * math.pi / 5
end

-- C function reference:
-- setpixel(x, y, i) sets a grayscale pixel with intensity i
-- setpixel(x, y, i, r, g, b) sets an RGB pixel
-- drawline(x0, y0, x1, y1, ...) draws a line
-- cleartexture() clears the entire texture

function render(time_in_millis)
   local phase = 2 * math.pi * time_in_millis / 10000
   cleartexture()

   local x0 = centerx + range * math.sin(phase)
   local y0 = centery + range * -math.cos(phase)

   for i = 0, 5, 1 do
      phase = phase + angledelta
      local x1 = centerx + range * math.sin(phase)
      local y1 = centery + range * -math.cos(phase)

      drawline(x0, y0, x1, y1, 255)

      x0 = x1
      y0 = y1
   end

end

