import java.io.*;

public class Java_AI_offwhite {

    public static void main(String argv[]) {


	Boss boss = new Boss();

	int move = boss.run();
	

	switch (move) {
	case 0: System.out.print("S"); break;
	case 1: System.out.print("E"); break;
	case 2: System.out.print("N"); break;
	case 3:	System.out.print("W"); break;
	default: System.out.print("S"); break;
	}
    }
}

class Boss {

    PrintWriter debug;

    char[][] grid;
    Square[][] map;

    int movesLeft;
    int width;
    int height;

    int myY, myX;
    int coins = 0;
    int mCoins = 0;

    Square me;
    BNode best;

    int choice;
    Boss(){
    }

    int run(){
	try{
	    readGrid();
      	    makeMap(me);
	    findBestProfit(me);
	    choice = finallY();
	}catch(Exception e){}
	return choice;
    }

    private void readGrid() {

	try {
	    BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));      
 	    movesLeft = Integer.parseInt(stdin.readLine());
	    width = Integer.parseInt(stdin.readLine());
	    height = Integer.parseInt(stdin.readLine());

	    map = new Square[height][width];
	
	    grid = new char[height][width];
	    for (int y = 0; y < height; y++) {
		grid[y] = stdin.readLine().toCharArray();
		boolean found = false;
		if (!found){
		    for (int x = 0; x <width; x++){
			if (grid[y][x]=='X'){
			    myY = y;
			    myX = x;
			    me = new Square(y,x,5);
			    map[y][x] = me;			 
			    found = true;
			    break;
			}
		    }
		}
	    }
	}
	catch (Exception e){}
    } 

    void makeMap(Square sq){

	int y = sq.myY;
	int x = sq.myX;

	grid[y][x] = '0';
	map[y][x] = sq;

	Square temp;
	temp = checkType(y+1,x,sq,0);
	if (temp!=null)
	    makeMap(temp);
	temp = checkType(y,x+1,sq,1);
	if (temp!=null)
	    makeMap(temp);
	temp = checkType(y-1,x,sq,2);
	if (temp!=null)
	    makeMap(temp);
	temp = checkType(y,x-1,sq,3);
	if (temp!=null)
	    makeMap(temp);	
    }


    Square checkType(int y, int x, Square prev, int dir){

	if (y>height || x>width || y<0 || x<0) return null;

	Square temp;
	if (grid[y][x]=='0'){
	    temp = map[y][x];
	    if (temp.type!=0){
		prev.neighbours[dir] = temp;
		temp.neighbours[(dir+2)%4] = prev;
	    }
	    return null;
	}
	else{
	    int type;
	    switch (grid[y][x]){
	    case'#': type=0; break;
	    case'M': type=1; break;
	    case' ': type=2; break;
	    case'.': type=3; coins++; break;
	    case'o': type=4; mCoins++; break;
	    default: return null;
	    }

	    temp = new Square(y, x, type);
	    map[y][x] = temp;

	    if (type!=0){
		prev.neighbours[dir] = temp;
		temp.neighbours[(dir+2)%4] = prev;
		if (type!=1){
		    return temp;
		}
		return null;
	    }
	    return null;
	}
	//return temp;
    }

    void findBestProfit(Square start){

	Money cash = new Money(new QNode(start));
	best = new BNode(new QNode(start));

	int timesLooped = 0;
	final int LIMIT = 40000;

	while (true){
	    timesLooped++;

	    QNode node = cash.remove();

	    if (node.steps>movesLeft || timesLooped>=LIMIT){
		checkWithBestNode(node);
		break;
	    }
	    if (cash.twoLvls[0].next==null){
		cash.twoLvls[0].next = cash.twoLvls[1].next;
		cash.twoLvls[1].next = null;
		cash.currentLvl++;
	    }
	    QNode newNode = null;
	    boolean deadEnd = true;
	    QNode beenThere = null;

	    for (int i=0; i<4; i++){
       
		if (node.sq.neighbours[i]!=null && i!=node.prevDir && node.doneThat[i]==false){	
		    
		    beenThere = find(node, node.sq.neighbours[i]);
		    
		    if (beenThere!=null){
			
			newNode = new QNode(beenThere.sq,
					    node.cash, node.steps+1, node.coins);
			boolean better = update(newNode);
			
			node.next = newNode;
			node.doneThat[i] = true;
			newNode.prev = node;
			newNode.prevDir = (i+2)%4;
			
			if (better) cash.add(newNode);
		    }
		    else {
			newNode = new QNode(node.sq.neighbours[i], node.cash, node.steps+1, node.coins);
			boolean better = calc(newNode);
			node.next = newNode;
			node.doneThat[i] = true;
			newNode.prev = node;
			newNode.prevDir = (i+2)%4;
			
			if (better){
			    cash.add(newNode);
			    newNode.sq.mark = true;
			}
		    }
		}
	    }
	    if (cash.isEmpty()) break;
	}
    }

    boolean update(QNode node){

	if (node.cash>node.sq.cash){
	    node.sq.cash = node.cash;
	    return true;
	}
	return false;
    }

    boolean calc(QNode newNode){


	int cash = newNode.cash;
	int coins = newNode.coins;
	int steps = newNode.steps;

	if (newNode.sq.type==3){
	    cash++;
	    coins++;
	}
	if (newNode.sq.type==4){
	    cash+=50;
	    coins++;
	}

	if (newNode.sq.mark)
	    if(cash<=newNode.sq.cash && steps>=newNode.sq.steps)
		return false;

	if (cash>=newNode.sq.cash || steps<=newNode.sq.steps){

	    newNode.cash = cash; newNode.sq.cash = cash;
	    newNode.coins = coins; newNode.sq.coins = coins;
	    checkWithBestNode(newNode);
	    return true;
	}

	return false;
    }

    QNode find(QNode node, Square next){

	QNode it = node;

	while (true){

	    if (it.sq==next)return it;
	    if (it.prev==null) return null;

	    it = it.prev;
	}
    }


    void checkWithBestNode(QNode theRising){

	if (theRising.cash>best.n.cash){
	    best.n = theRising;
	}
    }

    int finallY(){
	if (best.n.sq==me){
	    return -1;
	}

	int dir = -1;
	while (true){
	    dir = (best.n.prevDir+2)%4;
	    best.n = best.n.prev;
	    if (best.n.steps==0) break;
	} 
	return dir;
    }
}
    

class Square {

    int type;
    int myY, myX;

    boolean mark = false;

    int cash = 0;
    int coins = 0;
    int steps = 0;

    Square[] neighbours = new Square[4];

    Square(int y, int x, int type){
	this.type = type;
	myY = y;
	myX = x;
    }
}

    
class Money {

    int size;
    int currentLvl = 0;

    QNode[] twoLvls = {new QNode(null), new QNode(null)};

    Money(QNode me){
	twoLvls[0].next = me;
	size = 1;
	currentLvl = 0;
    }
    
    boolean isEmpty(){
	return size==0;
    }

    void add(QNode node){
	if(node.steps==currentLvl+1){
	    node.next = twoLvls[1].next;
	    twoLvls[1].next = node;
	}
	else if(node.steps==currentLvl){
	    node.next = twoLvls[0].next;
	    twoLvls[0].next = node;
	}
	size++;
    }

    QNode remove(){
	QNode temp = twoLvls[0].next;
	twoLvls[0].next = twoLvls[0].next.next;
	size--;
	return temp;
    }

}

class QNode{

    QNode next;

    Square sq;
    QNode prev;
    QNode neighbours[] = new QNode[4];
    int prevDir = -1;

    boolean[]doneThat = new boolean[4];
    boolean coinTaken = false;

    int cash = 0;
    int steps = 0;
    int coins = 0;

    QNode(Square sq){
	this.sq = sq;
    }

    QNode(Square sq, int cash, int steps, int coins){
	this.sq = sq;
	this.cash = cash;
	this.steps = steps;
	this.coins = coins;
    }
}

class BNode {

    QNode n;
    BNode(QNode n){
	this.n = n;
    }
}












