
#ifndef NUM_LIGHTS
	#define NUM_LIGHTS 2
#endif

#ifndef ADAPTIVE_STEPS
	#define ADAPTIVE_STEPS
#endif


#define FOG

varying vec3 normal;
varying vec3 lightDir[NUM_LIGHTS];
varying vec3 eye;
#ifdef FOG
	varying float fogFactor;
#endif

uniform sampler2D t_color;
uniform sampler2D t_normal;
uniform float time;

void main(void) {
	vec3 e = normalize(eye);


	vec2 texcoord = gl_TexCoord[0].xy;


	vec3 n = normalize(-1.0+2.0*texture2D(t_normal, texcoord).xyz);
	
	vec4 col = texture2D(t_color, texcoord);
	vec4 fambient = vec4(0.0);
	vec4 fdiff = vec4(0.0);
	vec4 fspec = vec4(0.0);

	for (int i = 0; i < NUM_LIGHTS; i++) {
		vec3 l = normalize(lightDir[i]);
		float diff = dot(n, l);

		fambient += gl_LightSource[i].ambient*diff;

		if (diff > 0.0) {
			fdiff += gl_LightSource[i].diffuse*diff;

			vec3 r = normalize(reflect(-l, n));
			fspec += vec4(gl_LightSource[i].specular.xyz, 1.0)*pow(max(dot(r, e), 0.0), gl_LightSource[i].specular.w);
		}
	}

	vec4 final = fambient*col + fdiff*col + fspec;

	#ifdef FOG
		float  fogFactor = clamp((gl_Fog.end-gl_FogFragCoord)*gl_Fog.scale, 0.0, 1.0);
		final = mix(gl_Fog.color, final, fogFactor);
	#endif

	gl_FragColor = final;
}
