
uniform sampler2D tex0;
uniform sampler2D tex1;
uniform sampler2D tex2;
uniform float mix;
uniform int inv;

vec4 lerppaa(vec4 a, vec4 b, float m) {
	float n = 1.0-m;
	return a*n + b*m;
}

void main() {
	vec4 col0 = texture2D(tex0, gl_TexCoord[0].xy);
	vec4 col1 = texture2D(tex1, gl_TexCoord[0].xy);
	vec4 col2 = texture2D(tex2, gl_TexCoord[0].xy);
	vec4 fincol = vec4(0.0);
	fincol = lerppaa(col1, col2, mix-1.0);
	if (mix < 1.0) fincol = lerppaa(col0, col1, mix);

	if (inv == 1) fincol = 1.0-fincol;
	gl_FragColor = fincol;
}
