uniform sampler2D tex;
uniform float mix;

void main()
	{
	vec4 a = texture2D( tex, vec2( max( gl_TexCoord[0].x - 0.01, 0.0 ), gl_TexCoord[0].y ) );
	vec4 b = texture2D( tex, vec2( min( gl_TexCoord[0].x + 0.01, 1.0 ), gl_TexCoord[0].y ) );
	vec4 col = texture2D( tex, gl_TexCoord[0].xy );
	col *= abs( sin( a.r + a.g + a.b ) );
	col *= min( abs( tan( b.r + b.g + b.b ) ), 1.5 );
	col = clamp( col, 0.0, 1.0 );
	vec4 fcol = col * mix + texture2D( tex, gl_TexCoord[0].xy ) * ( 1.0 - mix );
	fcol.a = gl_Color.a;
	gl_FragColor = fcol;
	}