/*****************************************************************
|
|      MPEG audio decoder. Test Player
|
|      (c) 1996-1998 MpegTV, LLC
|
 ****************************************************************/

/*
** This sample application shows how to use the Xaudio SYNC API to
** decode a bitstreams that is read from a file, without sending the
** decoded audio samples to an output module. This is usefull for 
** applications that want to decode a stream and get direct access to
** the decoded samples for some other purpose than actually playing
** them out to an output device.
**
** NOTES:
** for each of the decoded audio frames, the application prints out
** the fields of the output audio buffer. A real-world application
** would do something more with the decoded PCM samples, but this is 
** just to show how to use the API.
*/

/*----------------------------------------------------------------------
|       includes
+---------------------------------------------------------------------*/
#include <stdlib.h>
#include <stdio.h>

/* xaudio general includes */
#include "decoder.h"

/* xaudio plug-in modules */
#include "file_input.h"
#include "mpeg_codec.h"

/*----------------------------------------------------------------------
|       error
+---------------------------------------------------------------------*/
static void
error(const char *string, int code)
{
    fprintf(stderr, "%s [error %d: %s]\n",
            string, code, xaudio_error_string(code));
    exit(1);
}

/*----------------------------------------------------------------------
|       main
+---------------------------------------------------------------------*/
int 
main(int argc, char **argv)
{
    XA_DecoderInfo *decoder;
    int             status; 

    /* check arguments */
    if (argc != 2) {
        fprintf(stderr, "usage: xaplayer <filename>\n");
        exit(1);
    }

    /* create a decoder */
    if (decoder_new(&decoder) != XA_SUCCESS) {
        fprintf(stderr, "cannot create decoder");
        exit(1);
    }
    
    /* register mpeg audio codec */
    {
        XA_CodecModule module;

        mpeg_codec_module_register(&module);
        decoder_codec_module_register(decoder, &module);
    }

    /* register the file input module */
    {
        XA_InputModule module;

        file_input_module_register(&module);
        decoder_input_module_register(decoder, &module);
    }

    /* create and open input object, first arg is the file name */
    status = decoder_input_new(decoder, argv[1], XA_DECODER_INPUT_AUTOSELECT);
    if (status != XA_SUCCESS) {
        error("cannot create input [%d]\n", status);
        exit(1);
    }
    if (decoder_input_open(decoder) != XA_SUCCESS) {
        printf("cannot open input\n");
        exit(1);
    }

    do {
        status = decoder_decode(decoder, NULL);
        if (status == XA_SUCCESS) {
            printf("decoded buffer:\n");
            printf("changed          = %d\n", decoder->output_buffer->changed);
            printf("pcm_samples addr = %lx\n", 
                   (unsigned long)decoder->output_buffer->pcm_samples);
            printf("size             = %d\n", decoder->output_buffer->size);
            printf("bytes_per_sample = %d\n", decoder->output_buffer->bytes_per_sample);
            printf("channels         = %d\n", decoder->output_buffer->channels);
            printf("sample_rate      = %d\n", decoder->output_buffer->sample_rate);
        }
    } while(status == XA_SUCCESS ||
            status == XA_ERROR_TIMEOUT ||
            status == XA_ERROR_INVALID_FRAME);

    return 0;
}






