/*****************************************************************
|
|      XAUDIO SDK. Sample Input Filter
|
|      (c) 1996-1998 MpegTV, LLC
|      Author: Gilles Boccon-Gibod (gilles@mpegtv.com)
|
 ****************************************************************/

/*
** This is a sample input filter.
** This module shows a simple implementation of an input filter
** that does nothing except print messages or shows message windows 
** for each of the functions called, to show the order in which the 
** Xaudio library makes calls to the module's methods.
*/

/*----------------------------------------------------------------------
|       includes
+---------------------------------------------------------------------*/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
 
#include "decoder.h"
#include "xaudio.h"

/*----------------------------------------------------------------------
|       types
+---------------------------------------------------------------------*/
typedef struct {
    void           *input;
    XA_DecoderInfo *decoder;
} InputFilter;

/*----------------------------------------------------------------------
|       constants and macros
+---------------------------------------------------------------------*/
#ifdef WIN32
#include <windows.h>
#define TRACE(x) MessageBox(NULL, x, "Input Filter", MB_OK)
#else
#define TRACE(x) printf("INPUT FILTER: %s\n", (x))
#endif
#define TRACE_0(x) TRACE(x)
#define TRACE_1(x, a) {char s[256]; sprintf(s, (x), a); TRACE(s);}

/*----------------------------------------------------------------------
|       input_filter_get_name
+---------------------------------------------------------------------*/
static const char *
input_filter_get_name(void)
{
    return "sample-input-filter";
}

/*----------------------------------------------------------------------
|       input_filter_new
+---------------------------------------------------------------------*/
static int
input_filter_new(void **ret_filter,
                 int id,
                 XA_DecoderInfo *decoder)
{
    /* allocate an input filter object */
    InputFilter *filter = (InputFilter *)malloc(sizeof(InputFilter));
    if (filter == NULL) return XA_ERROR_OUT_OF_MEMORY;
    *ret_filter = (void *)filter;

    TRACE_1("input_filter_new, id=%d", id);

    /* store the parameters */
    filter->decoder = decoder;

    return XA_SUCCESS;
}

/*----------------------------------------------------------------------
|       input_filter_delete
+---------------------------------------------------------------------*/
static int
input_filter_delete(void *filter) 
{
    TRACE_0("input_filter_delete");

    if (filter) {
        free((void *)filter);
    }

    return XA_SUCCESS;
}

/*----------------------------------------------------------------------
|       input_filter_open
+---------------------------------------------------------------------*/
static int
input_filter_open(XA_InputFilterNode *node)
{
    TRACE_0("input_filter_open");

    /* call the next node */
    return node->next->vtable.input_open(node->next);

    return XA_SUCCESS;
}

/*----------------------------------------------------------------------
|       input_filter_close
+---------------------------------------------------------------------*/
static int
input_filter_close(XA_InputFilterNode *node)
{
    TRACE_0("input_filter_close");

    /* call the next node */
    return node->next->vtable.input_close(node->next);
}

/*----------------------------------------------------------------------
|       input_filter_read
+---------------------------------------------------------------------*/
static int
input_filter_read(XA_InputFilterNode *node, void *buffer, unsigned long size)
{
    TRACE_1("input_fiter_read, size=%ld", size);

    /* call the next node */
    return node->next->vtable.input_read(node->next, buffer, size);
}

/*----------------------------------------------------------------------
|       input_input_filter_register
+---------------------------------------------------------------------*/
int XA_EXPORT
input_filter_register(XA_InputFilter *filter)
{
    filter->filter_get_name    = input_filter_get_name;
    filter->filter_new         = input_filter_new;
    filter->filter_delete      = input_filter_delete;
    filter->input_open         = input_filter_open;
    filter->input_close        = input_filter_close;
    filter->input_read         = input_filter_read;
    filter->input_seek         = NULL;
    filter->input_get_caps     = NULL;
    filter->input_get_size     = NULL;
    filter->input_send_message = NULL;

    return XA_SUCCESS;
} 
