/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PMatrix;
import processing.core.PMatrix2D;
import processing.core.PMatrix3D;

public class PGraphicsJava2D
extends PGraphics {
    public Graphics2D g2;
    GeneralPath gpath;
    boolean breakShape;
    float[] curveCoordX;
    float[] curveCoordY;
    float[] curveDrawX;
    float[] curveDrawY;
    int transformCount;
    AffineTransform[] transformStack = new AffineTransform[32];
    double[] transform = new double[6];
    Line2D.Float line = new Line2D.Float();
    Ellipse2D.Float ellipse = new Ellipse2D.Float();
    Rectangle2D.Float rect = new Rectangle2D.Float();
    Arc2D.Float arc = new Arc2D.Float();
    protected Color tintColorObject;
    protected Color fillColorObject;
    public boolean fillGradient;
    public Paint fillGradientObject;
    protected Color strokeColorObject;
    public boolean strokeGradient;
    public Paint strokeGradientObject;
    int[] clearPixels;
    static int[] getset = new int[1];

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.width1 = this.width - 1;
        this.height1 = this.height - 1;
        this.allocate();
        this.reapplySettings();
    }

    protected void allocate() {
        this.image = new BufferedImage(this.width, this.height, 2);
        this.g2 = (Graphics2D)this.image.getGraphics();
    }

    public boolean canDraw() {
        return true;
    }

    public void beginDraw() {
        this.checkSettings();
        this.resetMatrix();
        this.vertexCount = 0;
    }

    public void endDraw() {
        if (!this.primarySurface) {
            this.loadPixels();
        }
        this.modified = true;
    }

    public void beginShape(int n) {
        this.shape = n;
        this.vertexCount = 0;
        this.curveVertexCount = 0;
        this.gpath = null;
    }

    public void texture(PImage pImage) {
        PGraphicsJava2D.showMethodWarning("texture");
    }

    public void vertex(float f, float f2) {
        this.curveVertexCount = 0;
        if (this.vertexCount == this.vertices.length) {
            float[][] fArray = new float[this.vertexCount << 1][36];
            System.arraycopy(this.vertices, 0, fArray, 0, this.vertexCount);
            this.vertices = fArray;
        }
        this.vertices[this.vertexCount][0] = f;
        this.vertices[this.vertexCount][1] = f2;
        ++this.vertexCount;
        switch (this.shape) {
            case 2: {
                this.point(f, f2);
                break;
            }
            case 4: {
                if (this.vertexCount % 2 != 0) break;
                this.line(this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], f, f2);
                break;
            }
            case 9: {
                if (this.vertexCount % 3 != 0) break;
                this.triangle(this.vertices[this.vertexCount - 3][0], this.vertices[this.vertexCount - 3][1], this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], f, f2);
                break;
            }
            case 10: {
                if (this.vertexCount < 3) break;
                this.triangle(this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], this.vertices[this.vertexCount - 1][0], this.vertices[this.vertexCount - 1][1], this.vertices[this.vertexCount - 3][0], this.vertices[this.vertexCount - 3][1]);
                break;
            }
            case 11: {
                if (this.vertexCount == 3) {
                    this.triangle(this.vertices[0][0], this.vertices[0][1], this.vertices[1][0], this.vertices[1][1], f, f2);
                    break;
                }
                if (this.vertexCount <= 3) break;
                this.gpath = new GeneralPath();
                this.gpath.moveTo(this.vertices[0][0], this.vertices[0][1]);
                this.gpath.lineTo(this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1]);
                this.gpath.lineTo(f, f2);
                this.drawShape(this.gpath);
                break;
            }
            case 16: {
                if (this.vertexCount % 4 != 0) break;
                this.quad(this.vertices[this.vertexCount - 4][0], this.vertices[this.vertexCount - 4][1], this.vertices[this.vertexCount - 3][0], this.vertices[this.vertexCount - 3][1], this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], f, f2);
                break;
            }
            case 17: {
                if (this.vertexCount < 4 || this.vertexCount % 2 != 0) break;
                this.quad(this.vertices[this.vertexCount - 4][0], this.vertices[this.vertexCount - 4][1], this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], f, f2, this.vertices[this.vertexCount - 3][0], this.vertices[this.vertexCount - 3][1]);
                break;
            }
            case 20: {
                if (this.gpath == null) {
                    this.gpath = new GeneralPath();
                    this.gpath.moveTo(f, f2);
                    break;
                }
                if (this.breakShape) {
                    this.gpath.moveTo(f, f2);
                    this.breakShape = false;
                    break;
                }
                this.gpath.lineTo(f, f2);
            }
        }
    }

    public void vertex(float f, float f2, float f3) {
        PGraphicsJava2D.showDepthWarningXYZ("vertex");
    }

    public void vertex(float f, float f2, float f3, float f4) {
        PGraphicsJava2D.showVariationWarning("vertex(x, y, u, v)");
    }

    public void vertex(float f, float f2, float f3, float f4, float f5) {
        PGraphicsJava2D.showDepthWarningXYZ("vertex");
    }

    public void breakShape() {
        this.breakShape = true;
    }

    public void endShape(int n) {
        if (this.gpath != null && this.shape == 20) {
            if (n == 2) {
                this.gpath.closePath();
            }
            this.drawShape(this.gpath);
        }
        this.shape = 0;
    }

    public void bezierVertex(float f, float f2, float f3, float f4, float f5, float f6) {
        this.bezierVertexCheck();
        this.gpath.curveTo(f, f2, f3, f4, f5, f6);
    }

    public void bezierVertex(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        PGraphicsJava2D.showDepthWarningXYZ("bezierVertex");
    }

    protected void curveVertexCheck() {
        super.curveVertexCheck();
        if (this.curveCoordX == null) {
            this.curveCoordX = new float[4];
            this.curveCoordY = new float[4];
            this.curveDrawX = new float[4];
            this.curveDrawY = new float[4];
        }
    }

    protected void curveVertexSegment(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.curveCoordX[0] = f;
        this.curveCoordY[0] = f2;
        this.curveCoordX[1] = f3;
        this.curveCoordY[1] = f4;
        this.curveCoordX[2] = f5;
        this.curveCoordY[2] = f6;
        this.curveCoordX[3] = f7;
        this.curveCoordY[3] = f8;
        this.curveToBezierMatrix.mult(this.curveCoordX, this.curveDrawX);
        this.curveToBezierMatrix.mult(this.curveCoordY, this.curveDrawY);
        if (this.gpath == null) {
            this.gpath = new GeneralPath();
            this.gpath.moveTo(this.curveDrawX[0], this.curveDrawY[0]);
        }
        this.gpath.curveTo(this.curveDrawX[1], this.curveDrawY[1], this.curveDrawX[2], this.curveDrawY[2], this.curveDrawX[3], this.curveDrawY[3]);
    }

    public void curveVertex(float f, float f2, float f3) {
        PGraphicsJava2D.showDepthWarningXYZ("curveVertex");
    }

    public void point(float f, float f2) {
        if (this.stroke) {
            this.line(f, f2, f + 1.0E-4f, f2 + 1.0E-4f);
        }
    }

    public void line(float f, float f2, float f3, float f4) {
        this.line.setLine(f, f2, f3, f4);
        this.strokeShape(this.line);
    }

    public void triangle(float f, float f2, float f3, float f4, float f5, float f6) {
        this.gpath = new GeneralPath();
        this.gpath.moveTo(f, f2);
        this.gpath.lineTo(f3, f4);
        this.gpath.lineTo(f5, f6);
        this.gpath.closePath();
        this.drawShape(this.gpath);
    }

    public void quad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f, f2);
        generalPath.lineTo(f3, f4);
        generalPath.lineTo(f5, f6);
        generalPath.lineTo(f7, f8);
        generalPath.closePath();
        this.drawShape(generalPath);
    }

    protected void rectImpl(float f, float f2, float f3, float f4) {
        this.rect.setFrame(f, f2, f3 - f, f4 - f2);
        this.drawShape(this.rect);
    }

    protected void ellipseImpl(float f, float f2, float f3, float f4) {
        this.ellipse.setFrame(f, f2, f3, f4);
        this.drawShape(this.ellipse);
    }

    protected void arcImpl(float f, float f2, float f3, float f4, float f5, float f6) {
        f5 = -f5 * 57.295776f;
        f6 = -f6 * 57.295776f;
        float f7 = f6 - f5;
        if (this.fill) {
            this.arc.setArc(f, f2, f3, f4, f5, f7, 2);
            this.fillShape(this.arc);
        }
        if (this.stroke) {
            this.arc.setArc(f, f2, f3, f4, f5, f7, 0);
            this.strokeShape(this.arc);
        }
    }

    protected void fillShape(Shape shape) {
        if (this.fillGradient) {
            this.g2.setPaint(this.fillGradientObject);
            this.g2.fill(shape);
        } else if (this.fill) {
            this.g2.setColor(this.fillColorObject);
            this.g2.fill(shape);
        }
    }

    protected void strokeShape(Shape shape) {
        if (this.strokeGradient) {
            this.g2.setPaint(this.strokeGradientObject);
            this.g2.draw(shape);
        } else if (this.stroke) {
            this.g2.setColor(this.strokeColorObject);
            this.g2.draw(shape);
        }
    }

    protected void drawShape(Shape shape) {
        if (this.fillGradient) {
            this.g2.setPaint(this.fillGradientObject);
            this.g2.fill(shape);
        } else if (this.fill) {
            this.g2.setColor(this.fillColorObject);
            this.g2.fill(shape);
        }
        if (this.strokeGradient) {
            this.g2.setPaint(this.strokeGradientObject);
            this.g2.draw(shape);
        } else if (this.stroke) {
            this.g2.setColor(this.strokeColorObject);
            this.g2.draw(shape);
        }
    }

    public void box(float f, float f2, float f3) {
        PGraphicsJava2D.showMethodWarning("box");
    }

    public void sphere(float f) {
        PGraphicsJava2D.showMethodWarning("sphere");
    }

    public void bezierDetail(int n) {
    }

    public void curveDetail(int n) {
    }

    public void smooth() {
        this.smooth = true;
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
    }

    public void noSmooth() {
        this.smooth = false;
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
    }

    protected void imageImpl(PImage pImage, float f, float f2, float f3, float f4, int n, int n2, int n3, int n4) {
        if (pImage.width <= 0 || pImage.height <= 0) {
            return;
        }
        if (pImage.getCache(this) == null) {
            pImage.setCache(this, new ImageCache(pImage));
            pImage.updatePixels();
            pImage.modified = true;
        }
        ImageCache imageCache = (ImageCache)pImage.getCache(this);
        if (this.tint && !imageCache.tinted || this.tint && imageCache.tintedColor != this.tintColor || !this.tint && imageCache.tinted) {
            pImage.updatePixels();
        }
        if (pImage.modified) {
            imageCache.update(this.tint, this.tintColor);
            pImage.modified = false;
        }
        this.g2.drawImage(((ImageCache)pImage.getCache((Object)this)).image, (int)f, (int)f2, (int)f3, (int)f4, n, n2, n3, n4, null);
    }

    public float textAscent() {
        Font font = this.textFont.getFont();
        if (font == null) {
            return super.textAscent();
        }
        FontMetrics fontMetrics = this.parent.getFontMetrics(font);
        return fontMetrics.getAscent();
    }

    public float textDescent() {
        Font font = this.textFont.getFont();
        if (font == null) {
            return super.textDescent();
        }
        FontMetrics fontMetrics = this.parent.getFontMetrics(font);
        return fontMetrics.getDescent();
    }

    protected boolean textModeCheck(int n) {
        return n == 4 || n == 256;
    }

    public void textSize(float f) {
        Font font = this.textFont.getFont();
        if (font != null) {
            Font font2 = font.deriveFont(f);
            this.g2.setFont(font2);
            this.textFont.setFont(font2);
        }
        super.textSize(f);
    }

    protected float textWidthImpl(char[] cArray, int n, int n2) {
        Font font = this.textFont.getFont();
        if (font == null) {
            return super.textWidthImpl(cArray, n, n2);
        }
        int n3 = n2 - n;
        FontMetrics fontMetrics = this.g2.getFontMetrics(font);
        return fontMetrics.charsWidth(cArray, n, n3);
    }

    protected void textLineImpl(char[] cArray, int n, int n2, float f, float f2) {
        Font font = this.textFont.getFont();
        if (font == null) {
            super.textLineImpl(cArray, n, n2, f, f2);
            return;
        }
        Object object = this.g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (object == null) {
            object = RenderingHints.VALUE_ANTIALIAS_DEFAULT;
        }
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.textFont.smooth ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        this.g2.setColor(this.fillColorObject);
        int n3 = n2 - n;
        this.g2.drawChars(cArray, n, n3, (int)(f + 0.5f), (int)(f2 + 0.5f));
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        this.textX = f + this.textWidthImpl(cArray, n, n2);
        this.textY = f2;
        this.textZ = 0.0f;
    }

    public void pushMatrix() {
        if (this.transformCount == this.transformStack.length) {
            throw new RuntimeException("pushMatrix() cannot use push more than " + this.transformStack.length + " times");
        }
        this.transformStack[this.transformCount] = this.g2.getTransform();
        ++this.transformCount;
    }

    public void popMatrix() {
        if (this.transformCount == 0) {
            throw new RuntimeException("missing a popMatrix() to go with that pushMatrix()");
        }
        --this.transformCount;
        this.g2.setTransform(this.transformStack[this.transformCount]);
    }

    public void translate(float f, float f2) {
        this.g2.translate(f, f2);
    }

    public void rotate(float f) {
        this.g2.rotate(f);
    }

    public void rotateX(float f) {
        PGraphicsJava2D.showDepthWarning("rotateX");
    }

    public void rotateY(float f) {
        PGraphicsJava2D.showDepthWarning("rotateY");
    }

    public void rotateZ(float f) {
        PGraphicsJava2D.showDepthWarning("rotateZ");
    }

    public void rotate(float f, float f2, float f3, float f4) {
        PGraphicsJava2D.showVariationWarning("rotate");
    }

    public void scale(float f) {
        this.g2.scale(f, f);
    }

    public void scale(float f, float f2) {
        this.g2.scale(f, f2);
    }

    public void scale(float f, float f2, float f3) {
        PGraphicsJava2D.showDepthWarningXYZ("scale");
    }

    public void resetMatrix() {
        this.g2.setTransform(new AffineTransform());
    }

    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6) {
        this.g2.transform(new AffineTransform(f, f4, f2, f5, f3, f6));
    }

    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        PGraphicsJava2D.showVariationWarning("applyMatrix");
    }

    public PMatrix getMatrix() {
        return this.getMatrix((PMatrix2D)null);
    }

    public PMatrix2D getMatrix(PMatrix2D pMatrix2D) {
        if (pMatrix2D == null) {
            pMatrix2D = new PMatrix2D();
        }
        this.g2.getTransform().getMatrix(this.transform);
        pMatrix2D.set((float)this.transform[0], (float)this.transform[2], (float)this.transform[4], (float)this.transform[1], (float)this.transform[3], (float)this.transform[5]);
        return pMatrix2D;
    }

    public PMatrix3D getMatrix(PMatrix3D pMatrix3D) {
        PGraphicsJava2D.showVariationWarning("getMatrix");
        return pMatrix3D;
    }

    public void setMatrix(PMatrix2D pMatrix2D) {
        this.g2.setTransform(new AffineTransform(pMatrix2D.m00, pMatrix2D.m10, pMatrix2D.m01, pMatrix2D.m11, pMatrix2D.m02, pMatrix2D.m12));
    }

    public void setMatrix(PMatrix3D pMatrix3D) {
        PGraphicsJava2D.showVariationWarning("setMatrix");
    }

    public void printMatrix() {
        this.getMatrix((PMatrix2D)null).print();
    }

    public float screenX(float f, float f2) {
        this.g2.getTransform().getMatrix(this.transform);
        return (float)this.transform[0] * f + (float)this.transform[2] * f2 + (float)this.transform[4];
    }

    public float screenY(float f, float f2) {
        this.g2.getTransform().getMatrix(this.transform);
        return (float)this.transform[1] * f + (float)this.transform[3] * f2 + (float)this.transform[5];
    }

    public float screenX(float f, float f2, float f3) {
        PGraphicsJava2D.showDepthWarningXYZ("screenX");
        return 0.0f;
    }

    public float screenY(float f, float f2, float f3) {
        PGraphicsJava2D.showDepthWarningXYZ("screenY");
        return 0.0f;
    }

    public float screenZ(float f, float f2, float f3) {
        PGraphicsJava2D.showDepthWarningXYZ("screenZ");
        return 0.0f;
    }

    public void strokeCap(int n) {
        super.strokeCap(n);
        this.strokeImpl();
    }

    public void strokeJoin(int n) {
        super.strokeJoin(n);
        this.strokeImpl();
    }

    public void strokeWeight(float f) {
        super.strokeWeight(f);
        this.strokeImpl();
    }

    protected void strokeImpl() {
        int n = 0;
        if (this.strokeCap == 2) {
            n = 1;
        } else if (this.strokeCap == 4) {
            n = 2;
        }
        int n2 = 2;
        if (this.strokeJoin == 8) {
            n2 = 0;
        } else if (this.strokeJoin == 2) {
            n2 = 1;
        }
        this.g2.setStroke(new BasicStroke(this.strokeWeight, n, n2));
    }

    protected void strokeFromCalc() {
        super.strokeFromCalc();
        this.strokeColorObject = new Color(this.strokeColor, true);
        this.strokeGradient = false;
    }

    protected void tintFromCalc() {
        super.tintFromCalc();
        this.tintColorObject = new Color(this.tintColor, true);
    }

    protected void fillFromCalc() {
        super.fillFromCalc();
        this.fillColorObject = new Color(this.fillColor, true);
        this.fillGradient = false;
    }

    public void backgroundImpl() {
        if (this.backgroundAlpha) {
            WritableRaster writableRaster = ((BufferedImage)this.image).getRaster();
            if (this.clearPixels == null || this.clearPixels.length < this.width) {
                this.clearPixels = new int[this.width];
            }
            Arrays.fill(this.clearPixels, this.backgroundColor);
            for (int i = 0; i < this.height; ++i) {
                writableRaster.setDataElements(0, i, this.width, 1, this.clearPixels);
            }
        } else {
            this.pushMatrix();
            this.resetMatrix();
            this.g2.setColor(new Color(this.backgroundColor));
            this.g2.fillRect(0, 0, this.width, this.height);
            this.popMatrix();
        }
    }

    public void beginRaw(PGraphics pGraphics) {
        PGraphicsJava2D.showMethodWarning("beginRaw");
    }

    public void endRaw() {
        PGraphicsJava2D.showMethodWarning("endRaw");
    }

    public void loadPixels() {
        if (this.pixels == null || this.pixels.length != this.width * this.height) {
            this.pixels = new int[this.width * this.height];
        }
        WritableRaster writableRaster = ((BufferedImage)this.image).getRaster();
        writableRaster.getDataElements(0, 0, this.width, this.height, this.pixels);
    }

    public void updatePixels() {
        WritableRaster writableRaster = ((BufferedImage)this.image).getRaster();
        writableRaster.setDataElements(0, 0, this.width, this.height, this.pixels);
    }

    public void updatePixels(int n, int n2, int n3, int n4) {
        if (n != 0 || n2 != 0 || n3 != this.width || n4 != this.height) {
            PGraphicsJava2D.showVariationWarning("updatePixels(x, y, w, h)");
        }
        this.updatePixels();
    }

    public void resize(int n, int n2) {
        PGraphicsJava2D.showMethodWarning("resize");
    }

    public int get(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return 0;
        }
        WritableRaster writableRaster = ((BufferedImage)this.image).getRaster();
        writableRaster.getDataElements(n, n2, getset);
        return getset[0];
    }

    public PImage getImpl(int n, int n2, int n3, int n4) {
        PImage pImage = new PImage(n3, n4);
        pImage.parent = this.parent;
        WritableRaster writableRaster = ((BufferedImage)this.image).getRaster();
        writableRaster.getDataElements(n, n2, n3, n4, pImage.pixels);
        return pImage;
    }

    public PImage get() {
        return this.get(0, 0, this.width, this.height);
    }

    public void set(int n, int n2, int n3) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return;
        }
        PGraphicsJava2D.getset[0] = n3;
        WritableRaster writableRaster = ((BufferedImage)this.image).getRaster();
        writableRaster.setDataElements(n, n2, getset);
    }

    protected void setImpl(int n, int n2, int n3, int n4, int n5, int n6, PImage pImage) {
        WritableRaster writableRaster = ((BufferedImage)this.image).getRaster();
        if (n3 == 0 && n4 == 0 && n5 == pImage.width && n6 == pImage.height) {
            writableRaster.setDataElements(n, n2, pImage.width, pImage.height, pImage.pixels);
        } else {
            PImage pImage2 = pImage.get(n3, n4, n5, n6);
            writableRaster.setDataElements(n, n2, pImage2.width, pImage2.height, pImage2.pixels);
        }
    }

    public void mask(int[] nArray) {
        PGraphicsJava2D.showMethodWarning("mask");
    }

    public void mask(PImage pImage) {
        PGraphicsJava2D.showMethodWarning("mask");
    }

    public void copy(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (n3 != n7 || n4 != n8) {
            this.copy(this, n, n2, n3, n4, n5, n6, n7, n8);
        } else {
            this.g2.copyArea(n, n2, n3, n4, n5 -= n, n6 -= n2);
        }
    }

    class ImageCache {
        PImage source;
        boolean tinted;
        int tintedColor;
        int[] tintedPixels;
        BufferedImage image;

        public ImageCache(PImage pImage) {
            this.source = pImage;
        }

        public void update(boolean bl, int n) {
            boolean bl2;
            boolean bl3;
            int n2 = 2;
            boolean bl4 = bl3 = (n & 0xFF000000) == -16777216;
            if (this.source.format == 1 && (!bl || bl && bl3)) {
                n2 = 1;
            }
            boolean bl5 = bl2 = this.image != null && this.image.getType() != n2;
            if (this.image == null || bl2) {
                this.image = new BufferedImage(this.source.width, this.source.height, n2);
            }
            WritableRaster writableRaster = this.image.getRaster();
            if (bl) {
                if (this.tintedPixels == null || this.tintedPixels.length != this.source.width) {
                    this.tintedPixels = new int[this.source.width];
                }
                int n3 = n >> 24 & 0xFF;
                int n4 = n >> 16 & 0xFF;
                int n5 = n >> 8 & 0xFF;
                int n6 = n & 0xFF;
                if (n2 == 1) {
                    int n7 = 0;
                    for (int i = 0; i < this.source.height; ++i) {
                        for (int j = 0; j < this.source.width; ++j) {
                            int n8 = this.source.pixels[n7++];
                            int n9 = n8 >> 16 & 0xFF;
                            int n10 = n8 >> 8 & 0xFF;
                            int n11 = n8 & 0xFF;
                            this.tintedPixels[j] = (n4 * n9 & 0xFF00) << 8 | n5 * n10 & 0xFF00 | (n6 * n11 & 0xFF00) >> 8;
                        }
                        writableRaster.setDataElements(0, i, this.source.width, 1, this.tintedPixels);
                    }
                } else if (n2 == 2) {
                    int n12 = 0;
                    for (int i = 0; i < this.source.height; ++i) {
                        int n13;
                        int n14;
                        int n15;
                        int n16;
                        int n17;
                        int n18;
                        if (this.source.format == 1) {
                            n18 = n & 0xFF000000;
                            for (n17 = 0; n17 < this.source.width; ++n17) {
                                n16 = this.source.pixels[n12++];
                                n15 = n16 >> 16 & 0xFF;
                                n14 = n16 >> 8 & 0xFF;
                                n13 = n16 & 0xFF;
                                this.tintedPixels[n17] = n18 | (n4 * n15 & 0xFF00) << 8 | n5 * n14 & 0xFF00 | (n6 * n13 & 0xFF00) >> 8;
                            }
                        } else if (this.source.format == 2) {
                            for (n18 = 0; n18 < this.source.width; ++n18) {
                                n17 = this.source.pixels[n12++];
                                n16 = n17 >> 24 & 0xFF;
                                n15 = n17 >> 16 & 0xFF;
                                n14 = n17 >> 8 & 0xFF;
                                n13 = n17 & 0xFF;
                                this.tintedPixels[n18] = (n3 * n16 & 0xFF00) << 16 | (n4 * n15 & 0xFF00) << 8 | n5 * n14 & 0xFF00 | (n6 * n13 & 0xFF00) >> 8;
                            }
                        } else if (this.source.format == 4) {
                            n18 = n & 0xFFFFFF;
                            for (n17 = 0; n17 < this.source.width; ++n17) {
                                n16 = this.source.pixels[n12++];
                                this.tintedPixels[n17] = (n3 * n16 & 0xFF00) << 16 | n18;
                            }
                        }
                        writableRaster.setDataElements(0, i, this.source.width, 1, this.tintedPixels);
                    }
                }
            } else {
                writableRaster.setDataElements(0, 0, this.source.width, this.source.height, this.source.pixels);
            }
            this.tinted = bl;
            this.tintedColor = n;
        }
    }
}

