/*
 * Decompiled with CFR 0.152.
 */
package quickhull3d;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import java.util.Iterator;
import java.util.Vector;
import quickhull3d.Face;
import quickhull3d.FaceList;
import quickhull3d.HalfEdge;
import quickhull3d.Point3d;
import quickhull3d.Vector3d;
import quickhull3d.Vertex;
import quickhull3d.VertexList;

public class QuickHull3D {
    public static final int CLOCKWISE = 1;
    public static final int INDEXED_FROM_ONE = 2;
    public static final int INDEXED_FROM_ZERO = 4;
    public static final int POINT_RELATIVE = 8;
    public static final double AUTOMATIC_TOLERANCE = -1.0;
    protected int findIndex = -1;
    protected double charLength;
    protected boolean debug = false;
    protected Vertex[] pointBuffer = new Vertex[0];
    protected int[] vertexPointIndices = new int[0];
    private Face[] discardedFaces = new Face[3];
    private Vertex[] maxVtxs = new Vertex[3];
    private Vertex[] minVtxs = new Vertex[3];
    protected Vector faces = new Vector(16);
    protected Vector horizon = new Vector(16);
    private FaceList newFaces = new FaceList();
    private VertexList unclaimed = new VertexList();
    private VertexList claimed = new VertexList();
    protected int numVertices;
    protected int numFaces;
    protected int numPoints;
    protected double explicitTolerance = -1.0;
    protected double tolerance;
    private static final double DOUBLE_PREC = 2.220446049250313E-16;
    private static final int NONCONVEX_WRT_LARGER_FACE = 1;
    private static final int NONCONVEX = 2;

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public double getDistanceTolerance() {
        return this.tolerance;
    }

    public void setExplicitDistanceTolerance(double d) {
        this.explicitTolerance = d;
    }

    public double getExplicitDistanceTolerance() {
        return this.explicitTolerance;
    }

    private void addPointToFace(Vertex vertex, Face face) {
        vertex.face = face;
        if (face.outside == null) {
            this.claimed.add(vertex);
        } else {
            this.claimed.insertBefore(vertex, face.outside);
        }
        face.outside = vertex;
    }

    private void removePointFromFace(Vertex vertex, Face face) {
        if (vertex == face.outside) {
            face.outside = vertex.next != null && vertex.next.face == face ? vertex.next : null;
        }
        this.claimed.delete(vertex);
    }

    private Vertex removeAllPointsFromFace(Face face) {
        if (face.outside != null) {
            Vertex vertex = face.outside;
            while (vertex.next != null && vertex.next.face == face) {
                vertex = vertex.next;
            }
            this.claimed.delete(face.outside, vertex);
            vertex.next = null;
            return face.outside;
        }
        return null;
    }

    public QuickHull3D() {
    }

    public QuickHull3D(double[] dArray) throws IllegalArgumentException {
        this.build(dArray, dArray.length / 3);
    }

    public QuickHull3D(Point3d[] point3dArray) throws IllegalArgumentException {
        this.build(point3dArray, point3dArray.length);
    }

    private HalfEdge findHalfEdge(Vertex vertex, Vertex vertex2) {
        Iterator iterator = this.faces.iterator();
        while (iterator.hasNext()) {
            HalfEdge halfEdge = ((Face)iterator.next()).findEdge(vertex, vertex2);
            if (halfEdge == null) continue;
            return halfEdge;
        }
        return null;
    }

    protected void setHull(double[] dArray, int n, int[][] nArray, int n2) {
        this.initBuffers(n);
        this.setPoints(dArray, n);
        this.computeMaxAndMin();
        for (int i = 0; i < n2; ++i) {
            Face face = Face.create(this.pointBuffer, nArray[i]);
            HalfEdge halfEdge = face.he0;
            do {
                HalfEdge halfEdge2;
                if ((halfEdge2 = this.findHalfEdge(halfEdge.head(), halfEdge.tail())) == null) continue;
                halfEdge.setOpposite(halfEdge2);
            } while ((halfEdge = halfEdge.next) != face.he0);
            this.faces.add(face);
        }
    }

    private void printQhullErrors(Process process) throws IOException {
        boolean bl = false;
        InputStream inputStream = process.getErrorStream();
        while (inputStream.available() > 0) {
            System.out.write(inputStream.read());
            bl = true;
        }
        if (bl) {
            System.out.println("");
        }
    }

    protected void setFromQhull(double[] dArray, int n, boolean bl) {
        String string = "./qhull i";
        if (bl) {
            string = string + " -Qt";
        }
        try {
            int n2;
            Process process = Runtime.getRuntime().exec(string);
            PrintStream printStream = new PrintStream(process.getOutputStream());
            StreamTokenizer streamTokenizer = new StreamTokenizer(new InputStreamReader(process.getInputStream()));
            printStream.println("3 " + n);
            for (int i = 0; i < n; ++i) {
                printStream.println(dArray[i * 3 + 0] + " " + dArray[i * 3 + 1] + " " + dArray[i * 3 + 2]);
            }
            printStream.flush();
            printStream.close();
            Vector<Integer> vector = new Vector<Integer>(3);
            streamTokenizer.eolIsSignificant(true);
            this.printQhullErrors(process);
            do {
                streamTokenizer.nextToken();
            } while (streamTokenizer.sval == null || !streamTokenizer.sval.startsWith("MERGEexact"));
            for (n2 = 0; n2 < 4; ++n2) {
                streamTokenizer.nextToken();
            }
            if (streamTokenizer.ttype != -2) {
                System.out.println("Expecting number of faces");
                System.exit(1);
            }
            n2 = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            int[][] nArrayArray = new int[n2][];
            for (int i = 0; i < n2; ++i) {
                vector.clear();
                while (streamTokenizer.nextToken() != 10) {
                    if (streamTokenizer.ttype != -2) {
                        System.out.println("Expecting face index");
                        System.exit(1);
                    }
                    vector.add(0, new Integer((int)streamTokenizer.nval));
                }
                nArrayArray[i] = new int[vector.size()];
                int n3 = 0;
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    nArrayArray[i][n3++] = (Integer)iterator.next();
                }
            }
            this.setHull(dArray, n, nArrayArray, n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    private void printPoints(PrintStream printStream) {
        for (int i = 0; i < this.numPoints; ++i) {
            Point3d point3d = this.pointBuffer[i].pnt;
            printStream.println(point3d.x + ", " + point3d.y + ", " + point3d.z + ",");
        }
    }

    public void build(double[] dArray) throws IllegalArgumentException {
        this.build(dArray, dArray.length / 3);
    }

    public void build(double[] dArray, int n) throws IllegalArgumentException {
        if (n < 4) {
            throw new IllegalArgumentException("Less than four input points specified");
        }
        if (dArray.length / 3 < n) {
            throw new IllegalArgumentException("Coordinate array too small for specified number of points");
        }
        this.initBuffers(n);
        this.setPoints(dArray, n);
        this.buildHull();
    }

    public void build(Point3d[] point3dArray) throws IllegalArgumentException {
        this.build(point3dArray, point3dArray.length);
    }

    public void build(Point3d[] point3dArray, int n) throws IllegalArgumentException {
        if (n < 4) {
            throw new IllegalArgumentException("Less than four input points specified");
        }
        if (point3dArray.length < n) {
            throw new IllegalArgumentException("Point array too small for specified number of points");
        }
        this.initBuffers(n);
        this.setPoints(point3dArray, n);
        this.buildHull();
    }

    public void triangulate() {
        double d = 1000.0 * this.charLength * 2.220446049250313E-16;
        this.newFaces.clear();
        Object object = this.faces.iterator();
        while (object.hasNext()) {
            Face face = (Face)object.next();
            if (face.mark != 1) continue;
            face.triangulate(this.newFaces, d);
        }
        object = this.newFaces.first();
        while (object != null) {
            this.faces.add(object);
            object = ((Face)object).next;
        }
    }

    protected void initBuffers(int n) {
        if (this.pointBuffer.length < n) {
            int n2;
            Vertex[] vertexArray = new Vertex[n];
            this.vertexPointIndices = new int[n];
            for (n2 = 0; n2 < this.pointBuffer.length; ++n2) {
                vertexArray[n2] = this.pointBuffer[n2];
            }
            for (n2 = this.pointBuffer.length; n2 < n; ++n2) {
                vertexArray[n2] = new Vertex();
            }
            this.pointBuffer = vertexArray;
        }
        this.faces.clear();
        this.claimed.clear();
        this.numFaces = 0;
        this.numPoints = n;
    }

    protected void setPoints(double[] dArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            Vertex vertex = this.pointBuffer[n2];
            vertex.pnt.set(dArray[n2 * 3 + 0], dArray[n2 * 3 + 1], dArray[n2 * 3 + 2]);
            vertex.index = n2++;
        }
    }

    protected void setPoints(Point3d[] point3dArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            Vertex vertex = this.pointBuffer[n2];
            vertex.pnt.set(point3dArray[n2]);
            vertex.index = n2++;
        }
    }

    protected void computeMaxAndMin() {
        int n;
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        for (n = 0; n < 3; ++n) {
            this.maxVtxs[n] = this.minVtxs[n] = this.pointBuffer[0];
        }
        vector3d.set(this.pointBuffer[0].pnt);
        vector3d2.set(this.pointBuffer[0].pnt);
        for (n = 1; n < this.numPoints; ++n) {
            Point3d point3d = this.pointBuffer[n].pnt;
            if (point3d.x > vector3d.x) {
                vector3d.x = point3d.x;
                this.maxVtxs[0] = this.pointBuffer[n];
            } else if (point3d.x < vector3d2.x) {
                vector3d2.x = point3d.x;
                this.minVtxs[0] = this.pointBuffer[n];
            }
            if (point3d.y > vector3d.y) {
                vector3d.y = point3d.y;
                this.maxVtxs[1] = this.pointBuffer[n];
            } else if (point3d.y < vector3d2.y) {
                vector3d2.y = point3d.y;
                this.minVtxs[1] = this.pointBuffer[n];
            }
            if (point3d.z > vector3d.z) {
                vector3d.z = point3d.z;
                this.maxVtxs[2] = this.pointBuffer[n];
                continue;
            }
            if (!(point3d.z < vector3d2.z)) continue;
            vector3d2.z = point3d.z;
            this.maxVtxs[2] = this.pointBuffer[n];
        }
        this.charLength = Math.max(vector3d.x - vector3d2.x, vector3d.y - vector3d2.y);
        this.charLength = Math.max(vector3d.z - vector3d2.z, this.charLength);
        this.tolerance = this.explicitTolerance == -1.0 ? 6.661338147750939E-16 * (Math.max(Math.abs(vector3d.x), Math.abs(vector3d2.x)) + Math.max(Math.abs(vector3d.y), Math.abs(vector3d2.y)) + Math.max(Math.abs(vector3d.z), Math.abs(vector3d2.z))) : this.explicitTolerance;
    }

    protected void createInitialSimplex() throws IllegalArgumentException {
        int n;
        int n2;
        double d = 0.0;
        int n3 = 0;
        for (int i = 0; i < 3; ++i) {
            double d2 = this.maxVtxs[i].pnt.get(i) - this.minVtxs[i].pnt.get(i);
            if (!(d2 > d)) continue;
            d = d2;
            n3 = i;
        }
        if (d <= this.tolerance) {
            throw new IllegalArgumentException("Input points appear to be coincident");
        }
        Vertex[] vertexArray = new Vertex[4];
        vertexArray[0] = this.maxVtxs[n3];
        vertexArray[1] = this.minVtxs[n3];
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        double d3 = 0.0;
        vector3d.sub(vertexArray[1].pnt, vertexArray[0].pnt);
        vector3d.normalize();
        for (int i = 0; i < this.numPoints; ++i) {
            vector3d2.sub(this.pointBuffer[i].pnt, vertexArray[0].pnt);
            vector3d4.cross(vector3d, vector3d2);
            double d4 = vector3d4.normSquared();
            if (!(d4 > d3) || this.pointBuffer[i] == vertexArray[0] || this.pointBuffer[i] == vertexArray[1]) continue;
            d3 = d4;
            vertexArray[2] = this.pointBuffer[i];
            vector3d3.set(vector3d4);
        }
        if (Math.sqrt(d3) <= 100.0 * this.tolerance) {
            throw new IllegalArgumentException("Input points appear to be colinear");
        }
        vector3d3.normalize();
        double d5 = 0.0;
        double d6 = vertexArray[2].pnt.dot(vector3d3);
        for (int i = 0; i < this.numPoints; ++i) {
            double d7 = Math.abs(this.pointBuffer[i].pnt.dot(vector3d3) - d6);
            if (!(d7 > d5) || this.pointBuffer[i] == vertexArray[0] || this.pointBuffer[i] == vertexArray[1] || this.pointBuffer[i] == vertexArray[2]) continue;
            d5 = d7;
            vertexArray[3] = this.pointBuffer[i];
        }
        if (Math.abs(d5) <= 100.0 * this.tolerance) {
            throw new IllegalArgumentException("Input points appear to be coplanar");
        }
        if (this.debug) {
            System.out.println("initial vertices:");
            System.out.println(vertexArray[0].index + ": " + vertexArray[0].pnt);
            System.out.println(vertexArray[1].index + ": " + vertexArray[1].pnt);
            System.out.println(vertexArray[2].index + ": " + vertexArray[2].pnt);
            System.out.println(vertexArray[3].index + ": " + vertexArray[3].pnt);
        }
        Face[] faceArray = new Face[4];
        if (vertexArray[3].pnt.dot(vector3d3) - d6 < 0.0) {
            faceArray[0] = Face.createTriangle(vertexArray[0], vertexArray[1], vertexArray[2]);
            faceArray[1] = Face.createTriangle(vertexArray[3], vertexArray[1], vertexArray[0]);
            faceArray[2] = Face.createTriangle(vertexArray[3], vertexArray[2], vertexArray[1]);
            faceArray[3] = Face.createTriangle(vertexArray[3], vertexArray[0], vertexArray[2]);
            for (n2 = 0; n2 < 3; ++n2) {
                n = (n2 + 1) % 3;
                faceArray[n2 + 1].getEdge(1).setOpposite(faceArray[n + 1].getEdge(0));
                faceArray[n2 + 1].getEdge(2).setOpposite(faceArray[0].getEdge(n));
            }
        } else {
            faceArray[0] = Face.createTriangle(vertexArray[0], vertexArray[2], vertexArray[1]);
            faceArray[1] = Face.createTriangle(vertexArray[3], vertexArray[0], vertexArray[1]);
            faceArray[2] = Face.createTriangle(vertexArray[3], vertexArray[1], vertexArray[2]);
            faceArray[3] = Face.createTriangle(vertexArray[3], vertexArray[2], vertexArray[0]);
            for (n2 = 0; n2 < 3; ++n2) {
                n = (n2 + 1) % 3;
                faceArray[n2 + 1].getEdge(0).setOpposite(faceArray[n + 1].getEdge(1));
                faceArray[n2 + 1].getEdge(2).setOpposite(faceArray[0].getEdge((3 - n2) % 3));
            }
        }
        for (n2 = 0; n2 < 4; ++n2) {
            this.faces.add(faceArray[n2]);
        }
        for (n2 = 0; n2 < this.numPoints; ++n2) {
            Vertex vertex = this.pointBuffer[n2];
            if (vertex == vertexArray[0] || vertex == vertexArray[1] || vertex == vertexArray[2] || vertex == vertexArray[3]) continue;
            d5 = this.tolerance;
            Face face = null;
            for (int i = 0; i < 4; ++i) {
                double d8 = faceArray[i].distanceToPlane(vertex.pnt);
                if (!(d8 > d5)) continue;
                face = faceArray[i];
                d5 = d8;
            }
            if (face == null) continue;
            this.addPointToFace(vertex, face);
        }
    }

    public int getNumVertices() {
        return this.numVertices;
    }

    public Point3d[] getVertices() {
        Point3d[] point3dArray = new Point3d[this.numVertices];
        for (int i = 0; i < this.numVertices; ++i) {
            point3dArray[i] = this.pointBuffer[this.vertexPointIndices[i]].pnt;
        }
        return point3dArray;
    }

    public int getVertices(double[] dArray) {
        for (int i = 0; i < this.numVertices; ++i) {
            Point3d point3d = this.pointBuffer[this.vertexPointIndices[i]].pnt;
            dArray[i * 3 + 0] = point3d.x;
            dArray[i * 3 + 1] = point3d.y;
            dArray[i * 3 + 2] = point3d.z;
        }
        return this.numVertices;
    }

    public int[] getVertexPointIndices() {
        int[] nArray = new int[this.numVertices];
        for (int i = 0; i < this.numVertices; ++i) {
            nArray[i] = this.vertexPointIndices[i];
        }
        return nArray;
    }

    public int getNumFaces() {
        return this.faces.size();
    }

    public int[][] getFaces() {
        return this.getFaces(0);
    }

    public int[][] getFaces(int n) {
        int[][] nArrayArray = new int[this.faces.size()][];
        int n2 = 0;
        Iterator iterator = this.faces.iterator();
        while (iterator.hasNext()) {
            Face face = (Face)iterator.next();
            nArrayArray[n2] = new int[face.numVertices()];
            this.getFaceIndices(nArrayArray[n2], face, n);
            ++n2;
        }
        return nArrayArray;
    }

    public void print(PrintStream printStream) {
        this.print(printStream, 0);
    }

    public void print(PrintStream printStream, int n) {
        Object object;
        if ((n & 4) == 0) {
            n |= 2;
        }
        for (int i = 0; i < this.numVertices; ++i) {
            object = this.pointBuffer[this.vertexPointIndices[i]].pnt;
            printStream.println("v " + ((Point3d)object).x + " " + ((Point3d)object).y + " " + ((Point3d)object).z);
        }
        Iterator iterator = this.faces.iterator();
        while (iterator.hasNext()) {
            object = (Face)iterator.next();
            int[] nArray = new int[((Face)object).numVertices()];
            this.getFaceIndices(nArray, (Face)object, n);
            printStream.print("f");
            for (int i = 0; i < nArray.length; ++i) {
                printStream.print(" " + nArray[i]);
            }
            printStream.println("");
        }
    }

    private void getFaceIndices(int[] nArray, Face face, int n) {
        boolean bl = (n & 1) == 0;
        boolean bl2 = (n & 2) != 0;
        boolean bl3 = (n & 8) != 0;
        HalfEdge halfEdge = face.he0;
        int n2 = 0;
        do {
            int n3 = halfEdge.head().index;
            if (bl3) {
                n3 = this.vertexPointIndices[n3];
            }
            if (bl2) {
                // empty if block
            }
            nArray[n2++] = ++n3;
        } while ((halfEdge = bl ? halfEdge.next : halfEdge.prev) != face.he0);
    }

    protected void resolveUnclaimedPoints(FaceList faceList) {
        Vertex vertex;
        Vertex vertex2 = vertex = this.unclaimed.first();
        while (vertex2 != null) {
            vertex = vertex2.next;
            double d = this.tolerance;
            Face face = null;
            Face face2 = faceList.first();
            while (face2 != null) {
                if (face2.mark == 1) {
                    double d2 = face2.distanceToPlane(vertex2.pnt);
                    if (d2 > d) {
                        d = d2;
                        face = face2;
                    }
                    if (d > 1000.0 * this.tolerance) break;
                }
                face2 = face2.next;
            }
            if (face != null) {
                this.addPointToFace(vertex2, face);
                if (this.debug && vertex2.index == this.findIndex) {
                    System.out.println(this.findIndex + " CLAIMED BY " + face.getVertexString());
                }
            } else if (this.debug && vertex2.index == this.findIndex) {
                System.out.println(this.findIndex + " DISCARDED");
            }
            vertex2 = vertex;
        }
    }

    protected void deleteFacePoints(Face face, Face face2) {
        Vertex vertex = this.removeAllPointsFromFace(face);
        if (vertex != null) {
            if (face2 == null) {
                this.unclaimed.addAll(vertex);
            } else {
                Vertex vertex2;
                Vertex vertex3 = vertex2 = vertex;
                while (vertex3 != null) {
                    vertex2 = vertex3.next;
                    double d = face2.distanceToPlane(vertex3.pnt);
                    if (d > this.tolerance) {
                        this.addPointToFace(vertex3, face2);
                    } else {
                        this.unclaimed.add(vertex3);
                    }
                    vertex3 = vertex2;
                }
            }
        }
    }

    protected double oppFaceDistance(HalfEdge halfEdge) {
        return halfEdge.face.distanceToPlane(halfEdge.opposite.face.getCentroid());
    }

    private boolean doAdjacentMerge(Face face, int n) {
        HalfEdge halfEdge = face.he0;
        boolean bl = true;
        do {
            Face face2 = halfEdge.oppositeFace();
            boolean bl2 = false;
            if (n == 2) {
                if (this.oppFaceDistance(halfEdge) > -this.tolerance || this.oppFaceDistance(halfEdge.opposite) > -this.tolerance) {
                    bl2 = true;
                }
            } else if (face.area > face2.area) {
                double d;
                double d2 = this.oppFaceDistance(halfEdge);
                if (d > -this.tolerance) {
                    bl2 = true;
                } else if (this.oppFaceDistance(halfEdge.opposite) > -this.tolerance) {
                    bl = false;
                }
            } else if (this.oppFaceDistance(halfEdge.opposite) > -this.tolerance) {
                bl2 = true;
            } else if (this.oppFaceDistance(halfEdge) > -this.tolerance) {
                bl = false;
            }
            if (!bl2) continue;
            if (this.debug) {
                System.out.println("  merging " + face.getVertexString() + "  and  " + face2.getVertexString());
            }
            int n2 = face.mergeAdjacentFace(halfEdge, this.discardedFaces);
            for (int i = 0; i < n2; ++i) {
                this.deleteFacePoints(this.discardedFaces[i], face);
            }
            if (this.debug) {
                System.out.println("  result: " + face.getVertexString());
            }
            return true;
        } while ((halfEdge = halfEdge.next) != face.he0);
        if (!bl) {
            face.mark = 2;
        }
        return false;
    }

    protected void calculateHorizon(Point3d point3d, HalfEdge halfEdge, Face face, Vector vector) {
        this.deleteFacePoints(face, null);
        face.mark = 3;
        if (this.debug) {
            System.out.println("  visiting face " + face.getVertexString());
        }
        HalfEdge halfEdge2 = halfEdge == null ? (halfEdge = face.getEdge(0)) : halfEdge.getNext();
        do {
            Face face2 = halfEdge2.oppositeFace();
            if (face2.mark != 1) continue;
            if (face2.distanceToPlane(point3d) > this.tolerance) {
                this.calculateHorizon(point3d, halfEdge2.getOpposite(), face2, vector);
                continue;
            }
            vector.add(halfEdge2);
            if (!this.debug) continue;
            System.out.println("  adding horizon edge " + halfEdge2.getVertexString());
        } while ((halfEdge2 = halfEdge2.getNext()) != halfEdge);
    }

    private HalfEdge addAdjoiningFace(Vertex vertex, HalfEdge halfEdge) {
        Face face = Face.createTriangle(vertex, halfEdge.tail(), halfEdge.head());
        this.faces.add(face);
        face.getEdge(-1).setOpposite(halfEdge.getOpposite());
        return face.getEdge(0);
    }

    protected void addNewFaces(FaceList faceList, Vertex vertex, Vector vector) {
        faceList.clear();
        HalfEdge halfEdge = null;
        HalfEdge halfEdge2 = null;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            HalfEdge halfEdge3 = (HalfEdge)iterator.next();
            HalfEdge halfEdge4 = this.addAdjoiningFace(vertex, halfEdge3);
            if (this.debug) {
                System.out.println("new face: " + halfEdge4.face.getVertexString());
            }
            if (halfEdge != null) {
                halfEdge4.next.setOpposite(halfEdge);
            } else {
                halfEdge2 = halfEdge4;
            }
            faceList.add(halfEdge4.getFace());
            halfEdge = halfEdge4;
        }
        halfEdge2.next.setOpposite(halfEdge);
    }

    protected Vertex nextPointToAdd() {
        if (!this.claimed.isEmpty()) {
            Face face = this.claimed.first().face;
            Vertex vertex = null;
            double d = 0.0;
            Vertex vertex2 = face.outside;
            while (vertex2 != null && vertex2.face == face) {
                double d2 = face.distanceToPlane(vertex2.pnt);
                if (d2 > d) {
                    d = d2;
                    vertex = vertex2;
                }
                vertex2 = vertex2.next;
            }
            return vertex;
        }
        return null;
    }

    protected void addPointToHull(Vertex vertex) {
        this.horizon.clear();
        this.unclaimed.clear();
        if (this.debug) {
            System.out.println("Adding point: " + vertex.index);
            System.out.println(" which is " + vertex.face.distanceToPlane(vertex.pnt) + " above face " + vertex.face.getVertexString());
        }
        this.removePointFromFace(vertex, vertex.face);
        this.calculateHorizon(vertex.pnt, null, vertex.face, this.horizon);
        this.newFaces.clear();
        this.addNewFaces(this.newFaces, vertex, this.horizon);
        Face face = this.newFaces.first();
        while (face != null) {
            if (face.mark == 1) {
                while (this.doAdjacentMerge(face, 1)) {
                }
            }
            face = face.next;
        }
        face = this.newFaces.first();
        while (face != null) {
            if (face.mark == 2) {
                face.mark = 1;
                while (this.doAdjacentMerge(face, 2)) {
                }
            }
            face = face.next;
        }
        this.resolveUnclaimedPoints(this.newFaces);
    }

    protected void buildHull() {
        Vertex vertex;
        int n = 0;
        this.computeMaxAndMin();
        this.createInitialSimplex();
        while ((vertex = this.nextPointToAdd()) != null) {
            this.addPointToHull(vertex);
            ++n;
            if (!this.debug) continue;
            System.out.println("iteration " + n + " done");
        }
        this.reindexFacesAndVertices();
        if (this.debug) {
            System.out.println("hull done");
        }
    }

    private void markFaceVertices(Face face, int n) {
        HalfEdge halfEdge;
        HalfEdge halfEdge2 = halfEdge = face.getFirstEdge();
        do {
            halfEdge2.head().index = n;
        } while ((halfEdge2 = halfEdge2.next) != halfEdge);
    }

    protected void reindexFacesAndVertices() {
        Object object;
        for (int i = 0; i < this.numPoints; ++i) {
            this.pointBuffer[i].index = -1;
        }
        this.numFaces = 0;
        Iterator iterator = this.faces.iterator();
        while (iterator.hasNext()) {
            object = (Face)iterator.next();
            if (((Face)object).mark != 1) {
                iterator.remove();
                continue;
            }
            this.markFaceVertices((Face)object, 0);
            ++this.numFaces;
        }
        this.numVertices = 0;
        for (int i = 0; i < this.numPoints; ++i) {
            object = this.pointBuffer[i];
            if (((Vertex)object).index != 0) continue;
            this.vertexPointIndices[this.numVertices] = i;
            ++this.numVertices;
            ((Vertex)object).index = ((Vertex)object).index;
        }
    }

    protected boolean checkFaceConvexity(Face face, double d, PrintStream printStream) {
        HalfEdge halfEdge = face.he0;
        do {
            face.checkConsistency();
            double d2 = this.oppFaceDistance(halfEdge);
            if (d2 > d) {
                if (printStream != null) {
                    printStream.println("Edge " + halfEdge.getVertexString() + " non-convex by " + d2);
                }
                return false;
            }
            d2 = this.oppFaceDistance(halfEdge.opposite);
            if (d2 > d) {
                if (printStream != null) {
                    printStream.println("Opposite edge " + halfEdge.opposite.getVertexString() + " non-convex by " + d2);
                }
                return false;
            }
            if (halfEdge.next.oppositeFace() != halfEdge.oppositeFace()) continue;
            if (printStream != null) {
                printStream.println("Redundant vertex " + halfEdge.head().index + " in face " + face.getVertexString());
            }
            return false;
        } while ((halfEdge = halfEdge.next) != face.he0);
        return true;
    }

    protected boolean checkFaces(double d, PrintStream printStream) {
        boolean bl = true;
        Iterator iterator = this.faces.iterator();
        while (iterator.hasNext()) {
            Face face = (Face)iterator.next();
            if (face.mark != 1 || this.checkFaceConvexity(face, d, printStream)) continue;
            bl = false;
        }
        return bl;
    }

    public boolean check(PrintStream printStream) {
        return this.check(printStream, this.getDistanceTolerance());
    }

    public boolean check(PrintStream printStream, double d) {
        double d2 = 10.0 * d;
        if (!this.checkFaces(this.tolerance, printStream)) {
            return false;
        }
        for (int i = 0; i < this.numPoints; ++i) {
            Point3d point3d = this.pointBuffer[i].pnt;
            Iterator iterator = this.faces.iterator();
            while (iterator.hasNext()) {
                double d3;
                Face face = (Face)iterator.next();
                if (face.mark != 1 || !((d3 = face.distanceToPlane(point3d)) > d2)) continue;
                if (printStream != null) {
                    printStream.println("Point " + i + " " + d3 + " above face " + face.getVertexString());
                }
                return false;
            }
        }
        return true;
    }
}

