/*
 * Decompiled with CFR 0.152.
 */
package megamu.mesh;

import megamu.mesh.IntArray;
import megamu.mesh.LinkedArray;
import megamu.mesh.MPolygon;
import quickhull3d.QuickHull3D;

public class Voronoi {
    float[][] edges;
    MPolygon[] regions;

    public Voronoi(float[][] points) {
        if (points.length < 1) {
            this.edges = new float[0][4];
            this.regions = new MPolygon[0];
            return;
        }
        double[] qPoints = new double[points.length * 3 + 9];
        int i = 0;
        while (i < points.length) {
            qPoints[i * 3] = points[i][0];
            qPoints[i * 3 + 1] = points[i][1];
            qPoints[i * 3 + 2] = -(points[i][0] * points[i][0] + points[i][1] * points[i][1]);
            ++i;
        }
        qPoints[qPoints.length - 9] = -8000.0;
        qPoints[qPoints.length - 8] = 0.0;
        qPoints[qPoints.length - 7] = -6.4E7;
        qPoints[qPoints.length - 6] = 8000.0;
        qPoints[qPoints.length - 5] = 8000.0;
        qPoints[qPoints.length - 4] = -1.28E8;
        qPoints[qPoints.length - 3] = 8000.0;
        qPoints[qPoints.length - 2] = -8000.0;
        qPoints[qPoints.length - 1] = -1.28E8;
        QuickHull3D quickHull = new QuickHull3D(qPoints);
        int[][] faces = quickHull.getFaces(9);
        int artifact = 0;
        double[][] dualPoints = new double[faces.length][2];
        int i2 = 0;
        while (i2 < faces.length) {
            if (faces[i2][0] >= points.length && faces[i2][1] >= points.length && faces[i2][2] >= points.length) {
                artifact = i2;
            }
            double x0 = qPoints[faces[i2][0] * 3 + 0];
            double y0 = qPoints[faces[i2][0] * 3 + 1];
            double x1 = qPoints[faces[i2][1] * 3 + 0];
            double y1 = qPoints[faces[i2][1] * 3 + 1];
            double x2 = qPoints[faces[i2][2] * 3 + 0];
            double y2 = qPoints[faces[i2][2] * 3 + 1];
            double v1x = 2.0 * (x1 - x0);
            double v1y = 2.0 * (y1 - y0);
            double v1z = x0 * x0 - x1 * x1 + y0 * y0 - y1 * y1;
            double v2x = 2.0 * (x2 - x0);
            double v2y = 2.0 * (y2 - y0);
            double v2z = x0 * x0 - x2 * x2 + y0 * y0 - y2 * y2;
            double tmpx = v1y * v2z - v1z * v2y;
            double tmpy = v1z * v2x - v1x * v2z;
            double tmpz = v1x * v2y - v1y * v2x;
            dualPoints[i2][0] = tmpx / tmpz;
            dualPoints[i2][1] = tmpy / tmpz;
            ++i2;
        }
        this.edges = new float[1][4];
        int edgeCount = 0;
        LinkedArray faceNet = new LinkedArray(faces.length);
        IntArray[] pointBuckets = new IntArray[points.length];
        int i3 = 0;
        while (i3 < points.length) {
            pointBuckets[i3] = new IntArray();
            ++i3;
        }
        i3 = 0;
        while (i3 < faces.length) {
            int f = 0;
            while (f < faces[i3].length) {
                if (faces[i3][f] < points.length) {
                    pointBuckets[faces[i3][f]].add(i3);
                }
                ++f;
            }
            int j = 0;
            while (j < i3) {
                if (i3 != artifact && j != artifact && this.isEdgeShared(faces[i3], faces[j])) {
                    faceNet.link(i3, j);
                    if (this.edges.length <= edgeCount) {
                        float[][] tmpedges = new float[this.edges.length * 2][4];
                        System.arraycopy(this.edges, 0, tmpedges, 0, this.edges.length);
                        this.edges = tmpedges;
                    }
                    this.edges[edgeCount][0] = (float)dualPoints[i3][0];
                    this.edges[edgeCount][1] = (float)dualPoints[i3][1];
                    this.edges[edgeCount][2] = (float)dualPoints[j][0];
                    this.edges[edgeCount][3] = (float)dualPoints[j][1];
                    ++edgeCount;
                }
                ++j;
            }
            ++i3;
        }
        float[][] tmpedges = new float[edgeCount][4];
        System.arraycopy(this.edges, 0, tmpedges, 0, tmpedges.length);
        this.edges = tmpedges;
        this.regions = new MPolygon[points.length];
        int i4 = 0;
        while (i4 < points.length) {
            IntArray faceOrder = new IntArray(pointBuckets[i4].length);
            int p = pointBuckets[i4].get(0);
            while (p >= 0) {
                faceOrder.add(p);
                int newP = -1;
                int k = 0;
                while (k < faceNet.get((int)p).linkCount) {
                    int neighbor = faceNet.get((int)p).links[k];
                    if (!faceOrder.contains(neighbor) && pointBuckets[i4].contains(neighbor)) {
                        newP = neighbor;
                        break;
                    }
                    ++k;
                }
                p = newP;
            }
            this.regions[i4] = new MPolygon(pointBuckets[i4].length);
            int f = 0;
            while (f < faceOrder.length) {
                int face = faceOrder.get(f);
                this.regions[i4].add((float)dualPoints[face][0], (float)dualPoints[face][1]);
                ++f;
            }
            ++i4;
        }
    }

    public MPolygon[] getRegions() {
        return this.regions;
    }

    public float[][] getEdges() {
        return this.edges;
    }

    protected boolean isEdgeShared(int[] face1, int[] face2) {
        int i = 0;
        while (i < face1.length) {
            int cur = face1[i];
            int next = face1[(i + 1) % face1.length];
            int j = 0;
            while (j < face2.length) {
                int from = face2[j];
                int to = face2[(j + 1) % face2.length];
                if (cur == from && next == to || cur == to && next == from) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }
}

