/*
 * Decompiled with CFR 0.152.
 */
package vitamin.scenesimple;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import javax.media.opengl.GL;
import vitamin.ShaderCGFX;
import vitamin.VTexture;
import vitamin.interpolation.Linear;
import vitamin.interpolation.Sine;
import vitamin.math.Matrix;
import vitamin.math.Vector2;
import vitamin.math.Vector3;
import vitamin.scenesimple.KeyFrame;
import vitamin.scenesimple.Material;
import vitamin.scenesimple.MeshChunk;
import vitamin.scenesimple.MultiMaterial;
import vitamin.scenesimple.Object;
import vitamin.scenesimple.StandardMaterial;
import vitamin.scenesimple.Triangle;
import vitamin.scenesimple.Vertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mesh
extends Object {
    String _matName;
    public Material _mat;
    public ArrayList<Vertex> _vertexList;
    public ArrayList<Vertex> _instanceVertexList;
    ArrayList<Triangle> _triangleList;
    ArrayList<Vector3> _triNormals;
    ArrayList<MeshChunk> _chunkList;
    boolean _hasTriStrip;
    int[] _triStripList;
    public ArrayList<Vector3> _deltas;
    public ArrayList<Float> _weights;
    public int _numOfChannels;
    ArrayList<KeyFrame> _keys;
    boolean _isVisible;
    boolean _hasNormals;
    boolean _hasTangents;
    Vector3 _scale;

    public Mesh() {
        this._name = "Mesh";
        this._hasNormals = false;
        this._hasTangents = false;
        this._hasTriStrip = false;
        this._scale = new Vector3(1.0f, 1.0f, 1.0f);
        this._vertexList = null;
        this._instanceVertexList = null;
        this._triangleList = null;
        this._triNormals = null;
        this._chunkList = null;
        this._vertexList = new ArrayList();
        this._instanceVertexList = new ArrayList();
        this._triangleList = new ArrayList();
        this._triNormals = new ArrayList();
        this._chunkList = new ArrayList();
        this._localMatrix = new Matrix();
    }

    public Mesh(String name) {
        this._name = name;
        this._hasTriStrip = false;
        this._scale = new Vector3(1.0f, 1.0f, 1.0f);
        this._vertexList = null;
        this._triangleList = null;
        this._triNormals = null;
        this._chunkList = null;
        this._vertexList = new ArrayList();
        this._triangleList = new ArrayList();
        this._triNormals = new ArrayList();
        this._chunkList = new ArrayList();
        this._localMatrix = new Matrix();
    }

    public void addVertex(float x, float y, float z) {
        if (this._vertexList == null) {
            this._vertexList = new ArrayList();
        }
        Vertex v = new Vertex(x, y, z);
        this._vertexList.add(v);
    }

    public void addVertex(Vector3 p) {
        if (this._vertexList == null) {
            this._vertexList = new ArrayList();
        }
        Vertex v = new Vertex(p);
        this._vertexList.add(v);
    }

    public void addVertex(Vector3 p, Vector3 n, Vector2 tex) {
        if (this._vertexList == null) {
            this._vertexList = new ArrayList();
        }
        Vertex v = new Vertex(p, n, tex);
        this._vertexList.add(v);
    }

    public void addVertex(Vertex v) {
        if (this._vertexList == null) {
            this._vertexList = new ArrayList();
        }
        this._vertexList.add(v);
    }

    public void addTriangle(int a, int b, int c) {
        if (this._triangleList == null) {
            this._triangleList = new ArrayList();
        }
        Triangle t = new Triangle(a, b, c);
        this._triangleList.add(t);
    }

    public void addTriangle(Triangle tri) {
        if (this._triangleList == null) {
            this._triangleList = new ArrayList();
        }
        this._triangleList.add(tri);
    }

    public void setMaterial(Material mat) {
        this._mat = mat;
        this._matName = this._mat._name;
    }

    public void computeNormals() {
        if (this._hasNormals) {
            System.err.println("Mesh '" + this._name + "' already has vertex normals. Don't compute again");
            return;
        }
        Vector3[] tmpNormals = new Vector3[this._triangleList.size()];
        int i = 0;
        while (i < this._triangleList.size()) {
            Triangle f = this._triangleList.get(i);
            Vector3 p0 = this._vertexList.get((int)f._a)._position;
            Vector3 p1 = this._vertexList.get((int)f._b)._position;
            Vector3 p2 = this._vertexList.get((int)f._c)._position;
            Vector3 e0 = Vector3.sub(p1, p0);
            Vector3 e1 = Vector3.sub(p2, p0);
            Vector3 normal = Vector3.cross(e1, e0);
            tmpNormals[i] = normal.copy();
            normal.normalize();
            this._triNormals.add(normal);
            ++i;
        }
        Vector3 n = new Vector3();
        int num = 0;
        int vi = 0;
        while (vi < this._vertexList.size()) {
            Vertex vertex = this._vertexList.get(vi);
            n.set(0.0f, 0.0f, 0.0f);
            int fi = 0;
            while (fi < this._triangleList.size()) {
                Triangle f = this._triangleList.get(fi);
                if (vi == f._a || vi == f._b || vi == f._c) {
                    ++num;
                    n.add(tmpNormals[fi]);
                }
                ++fi;
            }
            if (num > 1) {
                n.mul(1.0f / (float)num);
            }
            n.normalize();
            vertex._normal = n.copy();
            ++vi;
        }
        tmpNormals = null;
        this._hasNormals = true;
    }

    public boolean ComputeTBNMatrix() {
        if (this._hasTangents) {
            System.err.println("Mesh '" + this._name + "' already has vertex tangent vectors. Don't compute again");
            return false;
        }
        Vector3[] tan1 = new Vector3[this._vertexList.size()];
        Vector3[] tan2 = new Vector3[this._vertexList.size()];
        int i = 0;
        while (i < this._vertexList.size()) {
            tan1[i] = new Vector3();
            tan2[i] = new Vector3();
            ++i;
        }
        int fi = 0;
        fi = 0;
        while (fi < this._triangleList.size()) {
            Triangle t = this._triangleList.get(fi);
            int i1 = t._a;
            int i2 = t._b;
            int i3 = t._c;
            Vertex vert1 = this._vertexList.get(t._a);
            Vertex vert2 = this._vertexList.get(t._b);
            Vertex vert3 = this._vertexList.get(t._c);
            Vector3 v1 = vert1._position.clone();
            Vector3 v2 = vert2._position.clone();
            Vector3 v3 = vert3._position.clone();
            Vector2 w1 = vert1.getTexCoord().clone();
            Vector2 w2 = vert2.getTexCoord().clone();
            Vector2 w3 = vert3.getTexCoord().clone();
            float Px = v2.x - v1.x;
            float Py = v2.y - v1.y;
            float Pz = v2.z - v1.z;
            float Qx = v3.x - v1.x;
            float Qy = v3.y - v1.y;
            float Qz = v3.z - v1.z;
            float s1 = w2.x - w1.x;
            float t1 = w2.y - w1.y;
            float s2 = w3.x - w1.x;
            float t2 = w3.y - w1.y;
            float r = 1.0f / (s1 * t2 - s2 * t1);
            Vector3 T = new Vector3((t2 * Px - t1 * Qx) * r, (t2 * Py - t1 * Qy) * r, (t2 * Pz - t1 * Qz) * r);
            Vector3 B = new Vector3((-s2 * Px + s1 * Qx) * r, (-s2 * Py + s2 * Qy) * r, (-s2 * Pz + s2 * Qz) * r);
            tan1[i1].add(T);
            tan1[i2].add(T);
            tan1[i3].add(T);
            tan2[i1].add(B);
            tan2[i2].add(B);
            tan2[i3].add(B);
            ++fi;
        }
        int vi = 0;
        vi = 0;
        while (vi < this._vertexList.size()) {
            Vector3 T = tan1[vi];
            T.normalize();
            this._vertexList.get(vi).setTangent(T.x, T.y, T.z);
            ++vi;
        }
        tan1 = null;
        tan2 = null;
        this._hasTangents = true;
        return true;
    }

    public void setScale(float sx, float sy, float sz) {
        this._scale.set(sx, sy, sz);
    }

    public void processChunks() {
        int i = 0;
        while (i < this._vertexList.size()) {
            this._vertexList.get(i).getPosition().mul(this._scale);
            ++i;
        }
        i = 0;
        while (i < this._vertexList.size()) {
            this._instanceVertexList.add(this._vertexList.get(i).copy());
            ++i;
        }
        if (this._mat._type == Material.eMaterialType.STANDARD) {
            MeshChunk mc = new MeshChunk();
            mc._owner = this;
            mc._mat = this._mat;
            mc._numOfVertices = this._vertexList.size();
            mc._numOfTris = this._triangleList.size();
            mc._numOfIndices = this._triangleList.size() * 3;
            int i2 = 0;
            i2 = 0;
            while (i2 < this._triangleList.size()) {
                Triangle t = this._triangleList.get(i2);
                mc._triList.add(t);
                mc._indexList.add(t._a);
                mc._indexList.add(t._b);
                mc._indexList.add(t._c);
                ++i2;
            }
            this._chunkList.add(mc);
        } else if (this._mat._type == Material.eMaterialType.MULTI) {
            MultiMaterial mmat = (MultiMaterial)this._mat;
            int mi = 0;
            mi = 0;
            while (mi < mmat._numSubMaterials) {
                MeshChunk mc = new MeshChunk();
                mc._owner = this;
                mc._mat = (StandardMaterial)mmat._matList.get(mi);
                int i3 = 0;
                i3 = 0;
                while (i3 < this._triangleList.size()) {
                    Triangle t = this._triangleList.get(i3);
                    if (mi == t._matId) {
                        mc._triList.add(t);
                        mc._indexList.add(t._a);
                        mc._indexList.add(t._b);
                        mc._indexList.add(t._c);
                    }
                    ++i3;
                }
                this._chunkList.add(mc);
                ++mi;
            }
        }
    }

    public void renderChunks(GL gl, ShaderCGFX shader) {
        if (this._mat != null) {
            if (this._mat._type == Material.eMaterialType.STANDARD) {
                boolean hasTex = true;
                StandardMaterial smat = (StandardMaterial)this._mat;
                try {
                    VTexture tex = smat._texList.get(0);
                    gl.glEnable(3553);
                    if (tex != null) {
                        gl.glBindTexture(3553, tex.getId());
                    }
                    hasTex = true;
                }
                catch (Exception e) {
                    hasTex = false;
                    gl.glDisable(3553);
                    gl.glBindTexture(3553, 0);
                }
                if (shader != null) {
                    try {
                        VTexture tex0 = smat._texList.get(0);
                        shader.setTextureParameter("ColorSampler", tex0.getId());
                    }
                    catch (Exception tex0) {
                        // empty catch block
                    }
                    try {
                        VTexture tex1 = smat._texList.get(1);
                        shader.setTextureParameter("NormalSampler", tex1.getId());
                    }
                    catch (Exception tex1) {
                        // empty catch block
                    }
                    try {
                        VTexture tex2 = smat._texList.get(2);
                        shader.setTextureParameter("AOSampler", tex2.getId());
                    }
                    catch (Exception tex2) {
                        // empty catch block
                    }
                    try {
                        shader.setFirstTechnique();
                        shader.setPass();
                    }
                    catch (Exception tex2) {
                        // empty catch block
                    }
                }
                float[] emis = new float[]{smat._emissive.x, smat._emissive.y, smat._emissive.z, smat._emissive.w};
                float[] amb = new float[]{smat._ambient.x, smat._ambient.y, smat._ambient.z, smat._ambient.w};
                float[] diff = new float[]{smat._diffuse.x, smat._diffuse.y, smat._diffuse.z, smat._diffuse.w};
                float[] spec = new float[]{smat._specular.x, smat._specular.y, smat._specular.z, smat._specular.w};
                float[] shininess = new float[]{smat._specularLevel};
                gl.glMaterialfv(1032, 5632, emis, 0);
                gl.glMaterialfv(1032, 4608, amb, 0);
                gl.glMaterialfv(1032, 4609, diff, 0);
                gl.glMaterialfv(1032, 4610, spec, 0);
                gl.glMaterialfv(1032, 5633, shininess, 0);
                int i = 0;
                gl.glBegin(4);
                i = 0;
                while (i < this._triangleList.size()) {
                    Triangle t = this._triangleList.get(i);
                    Vertex v0 = this._vertexList.get(t._a);
                    Vertex v1 = this._vertexList.get(t._b);
                    Vertex v2 = this._vertexList.get(t._c);
                    gl.glColor4f(v0._color.x, v0._color.y, v0._color.z, v0._color.w);
                    gl.glNormal3f(v0._normal.x, v0._normal.y, v0._normal.z);
                    if (hasTex) {
                        gl.glTexCoord2f(v0._texCoord.x, v0._texCoord.y);
                    }
                    gl.glMultiTexCoord3f(33985, v0._tangent.x, v0._tangent.y, v0._tangent.z);
                    gl.glVertex3f(v0._position.x, v0._position.y, v0._position.z);
                    gl.glColor4f(v1._color.x, v1._color.y, v1._color.z, v1._color.w);
                    gl.glNormal3f(v1._normal.x, v1._normal.y, v1._normal.z);
                    if (hasTex) {
                        gl.glTexCoord2f(v1._texCoord.x, v1._texCoord.y);
                    }
                    gl.glMultiTexCoord3f(33985, v1._tangent.x, v1._tangent.y, v1._tangent.z);
                    gl.glVertex3f(v1._position.x, v1._position.y, v1._position.z);
                    gl.glColor4f(v2._color.x, v2._color.y, v2._color.z, v2._color.w);
                    gl.glNormal3f(v2._normal.x, v2._normal.y, v2._normal.z);
                    if (hasTex) {
                        gl.glTexCoord2f(v2._texCoord.x, v2._texCoord.y);
                    }
                    gl.glMultiTexCoord3f(33985, v2._tangent.x, v2._tangent.y, v2._tangent.z);
                    gl.glVertex3f(v2._position.x, v2._position.y, v2._position.z);
                    ++i;
                }
                gl.glEnd();
                if (shader != null) {
                    try {
                        shader.resetPass();
                    }
                    catch (Exception t) {}
                }
            } else if (this._mat._type == Material.eMaterialType.MULTI) {
                MultiMaterial mmat = (MultiMaterial)this._mat;
                int i = 0;
                i = 0;
                while (i < mmat._numSubMaterials) {
                    StandardMaterial smat = (StandardMaterial)mmat._matList.get(i);
                    boolean hasTex = false;
                    try {
                        VTexture tex = smat._texList.get(0);
                        gl.glEnable(3553);
                        if (tex != null) {
                            gl.glBindTexture(3553, tex.getId());
                        }
                        hasTex = true;
                    }
                    catch (Exception e) {
                        hasTex = false;
                        gl.glDisable(3553);
                        gl.glBindTexture(3553, 0);
                    }
                    if (shader != null) {
                        try {
                            VTexture tex0 = smat._texList.get(0);
                            shader.setTextureParameter("ColorSampler", tex0.getId());
                        }
                        catch (Exception tex0) {
                            // empty catch block
                        }
                        try {
                            VTexture tex1 = smat._texList.get(1);
                            shader.setTextureParameter("NormalSampler", tex1.getId());
                        }
                        catch (Exception tex1) {
                            // empty catch block
                        }
                        try {
                            VTexture tex2 = smat._texList.get(2);
                            shader.setTextureParameter("AOSampler", tex2.getId());
                        }
                        catch (Exception tex2) {
                            // empty catch block
                        }
                        try {
                            shader.setFirstTechnique();
                            shader.setPass();
                        }
                        catch (Exception tex2) {
                            // empty catch block
                        }
                    }
                    float[] emis = new float[]{smat._emissive.x, smat._emissive.y, smat._emissive.z, smat._emissive.w};
                    float[] amb = new float[]{smat._ambient.x, smat._ambient.y, smat._ambient.z, smat._ambient.w};
                    float[] diff = new float[]{smat._diffuse.x, smat._diffuse.y, smat._diffuse.z, smat._diffuse.w};
                    float[] spec = new float[]{smat._specular.x, smat._specular.y, smat._specular.z, smat._specular.w};
                    float[] shininess = new float[]{smat._specularLevel};
                    gl.glMaterialfv(1032, 5632, emis, 0);
                    gl.glMaterialfv(1032, 4608, amb, 0);
                    gl.glMaterialfv(1032, 4609, diff, 0);
                    gl.glMaterialfv(1032, 4610, spec, 0);
                    gl.glMaterialfv(1032, 5633, shininess, 0);
                    MeshChunk mc = this._chunkList.get(i);
                    int ti = 0;
                    gl.glBegin(4);
                    ti = 0;
                    while (ti < mc._triList.size()) {
                        Triangle t = mc._triList.get(ti);
                        Vertex v0 = this._vertexList.get(t._a);
                        Vertex v1 = this._vertexList.get(t._b);
                        Vertex v2 = this._vertexList.get(t._c);
                        gl.glColor4f(v0._color.x, v0._color.y, v0._color.z, v0._color.w);
                        gl.glNormal3f(v0._normal.x, v0._normal.y, v0._normal.z);
                        if (hasTex) {
                            gl.glTexCoord2f(v0._texCoord.x, v0._texCoord.y);
                        }
                        gl.glMultiTexCoord3f(33985, v0._tangent.x, v0._tangent.y, v0._tangent.z);
                        gl.glVertex3f(v0._position.x, v0._position.y, v0._position.z);
                        gl.glColor4f(v1._color.x, v1._color.y, v1._color.z, v1._color.w);
                        gl.glNormal3f(v1._normal.x, v1._normal.y, v1._normal.z);
                        if (hasTex) {
                            gl.glTexCoord2f(v1._texCoord.x, v1._texCoord.y);
                        }
                        gl.glMultiTexCoord3f(33985, v1._tangent.x, v1._tangent.y, v1._tangent.z);
                        gl.glVertex3f(v1._position.x, v1._position.y, v1._position.z);
                        gl.glColor4f(v2._color.x, v2._color.y, v2._color.z, v2._color.w);
                        gl.glNormal3f(v2._normal.x, v2._normal.y, v2._normal.z);
                        if (hasTex) {
                            gl.glTexCoord2f(v2._texCoord.x, v2._texCoord.y);
                        }
                        gl.glMultiTexCoord3f(33985, v2._tangent.x, v2._tangent.y, v2._tangent.z);
                        gl.glVertex3f(v2._position.x, v2._position.y, v2._position.z);
                        ++ti;
                    }
                    gl.glEnd();
                    if (shader != null) {
                        try {
                            shader.resetPass();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public void renderChunksNoMaterial(GL gl) {
        if (this._mat != null) {
            if (this._mat._type == Material.eMaterialType.STANDARD) {
                StandardMaterial smat = (StandardMaterial)this._mat;
                int i = 0;
                gl.glBegin(4);
                i = 0;
                while (i < this._triangleList.size()) {
                    Triangle t = this._triangleList.get(i);
                    Vertex v0 = this._vertexList.get(t._a);
                    Vertex v1 = this._vertexList.get(t._b);
                    Vertex v2 = this._vertexList.get(t._c);
                    gl.glColor4f(smat._diffuse.x, smat._diffuse.y, smat._diffuse.z, smat._diffuse.w);
                    gl.glNormal3f(v0._normal.x, v0._normal.y, v0._normal.z);
                    gl.glTexCoord2f(v0._texCoord.x, v0._texCoord.y);
                    gl.glMultiTexCoord3f(33985, v0._tangent.x, v0._tangent.y, v0._tangent.z);
                    gl.glVertex3f(v0._position.x, v0._position.y, v0._position.z);
                    gl.glColor4f(smat._diffuse.x, smat._diffuse.y, smat._diffuse.z, smat._diffuse.w);
                    gl.glNormal3f(v1._normal.x, v1._normal.y, v1._normal.z);
                    gl.glTexCoord2f(v1._texCoord.x, v1._texCoord.y);
                    gl.glMultiTexCoord3f(33985, v1._tangent.x, v1._tangent.y, v1._tangent.z);
                    gl.glVertex3f(v1._position.x, v1._position.y, v1._position.z);
                    gl.glColor4f(smat._diffuse.x, smat._diffuse.y, smat._diffuse.z, smat._diffuse.w);
                    gl.glNormal3f(v2._normal.x, v2._normal.y, v2._normal.z);
                    gl.glTexCoord2f(v2._texCoord.x, v2._texCoord.y);
                    gl.glMultiTexCoord3f(33985, v2._tangent.x, v2._tangent.y, v2._tangent.z);
                    gl.glVertex3f(v2._position.x, v2._position.y, v2._position.z);
                    ++i;
                }
                gl.glEnd();
            } else if (this._mat._type == Material.eMaterialType.MULTI) {
                MultiMaterial mmat = (MultiMaterial)this._mat;
                int i = 0;
                i = 0;
                while (i < mmat._numSubMaterials) {
                    StandardMaterial smat = (StandardMaterial)mmat._matList.get(i);
                    MeshChunk mc = this._chunkList.get(i);
                    int ti = 0;
                    gl.glBegin(4);
                    ti = 0;
                    while (ti < mc._triList.size()) {
                        Triangle t = mc._triList.get(ti);
                        Vertex v0 = this._vertexList.get(t._a);
                        Vertex v1 = this._vertexList.get(t._b);
                        Vertex v2 = this._vertexList.get(t._c);
                        gl.glColor4f(smat._diffuse.x, smat._diffuse.y, smat._diffuse.z, smat._diffuse.w);
                        gl.glNormal3f(v0._normal.x, v0._normal.y, v0._normal.z);
                        gl.glTexCoord2f(v0._texCoord.x, v0._texCoord.y);
                        gl.glMultiTexCoord3f(33985, v0._tangent.x, v0._tangent.y, v0._tangent.z);
                        gl.glVertex3f(v0._position.x, v0._position.y, v0._position.z);
                        gl.glColor4f(smat._diffuse.x, smat._diffuse.y, smat._diffuse.z, smat._diffuse.w);
                        gl.glNormal3f(v1._normal.x, v1._normal.y, v1._normal.z);
                        gl.glTexCoord2f(v1._texCoord.x, v1._texCoord.y);
                        gl.glMultiTexCoord3f(33985, v1._tangent.x, v1._tangent.y, v1._tangent.z);
                        gl.glVertex3f(v1._position.x, v1._position.y, v1._position.z);
                        gl.glColor4f(smat._diffuse.x, smat._diffuse.y, smat._diffuse.z, smat._diffuse.w);
                        gl.glNormal3f(v2._normal.x, v2._normal.y, v2._normal.z);
                        gl.glTexCoord2f(v2._texCoord.x, v2._texCoord.y);
                        gl.glMultiTexCoord3f(33985, v2._tangent.x, v2._tangent.y, v2._tangent.z);
                        gl.glVertex3f(v2._position.x, v2._position.y, v2._position.z);
                        ++ti;
                    }
                    gl.glEnd();
                    ++i;
                }
            }
        }
    }

    public void renderChunksRaw(GL gl) {
        if (this._mat != null) {
            if (this._mat._type == Material.eMaterialType.STANDARD) {
                boolean hasTex = true;
                StandardMaterial smat = (StandardMaterial)this._mat;
                try {
                    VTexture tex = smat._texList.get(0);
                    gl.glEnable(3553);
                    if (tex != null) {
                        gl.glBindTexture(3553, tex.getId());
                    }
                    hasTex = true;
                }
                catch (Exception e) {
                    hasTex = false;
                    gl.glDisable(3553);
                    gl.glBindTexture(3553, 0);
                }
                int i = 0;
                gl.glBegin(4);
                i = 0;
                while (i < this._triangleList.size()) {
                    Triangle t = this._triangleList.get(i);
                    Vertex v0 = this._vertexList.get(t._a);
                    Vertex v1 = this._vertexList.get(t._b);
                    Vertex v2 = this._vertexList.get(t._c);
                    gl.glColor4f(v0._color.x, v0._color.y, v0._color.z, v0._color.w);
                    gl.glNormal3f(v0._normal.x, v0._normal.y, v0._normal.z);
                    if (hasTex) {
                        gl.glTexCoord2f(v0._texCoord.x, v0._texCoord.y);
                    }
                    gl.glVertex3f(v0._position.x, v0._position.y, v0._position.z);
                    gl.glColor4f(v1._color.x, v1._color.y, v1._color.z, v1._color.w);
                    gl.glNormal3f(v1._normal.x, v1._normal.y, v1._normal.z);
                    if (hasTex) {
                        gl.glTexCoord2f(v1._texCoord.x, v1._texCoord.y);
                    }
                    gl.glVertex3f(v1._position.x, v1._position.y, v1._position.z);
                    gl.glColor4f(v2._color.x, v2._color.y, v2._color.z, v2._color.w);
                    gl.glNormal3f(v2._normal.x, v2._normal.y, v2._normal.z);
                    if (hasTex) {
                        gl.glTexCoord2f(v2._texCoord.x, v2._texCoord.y);
                    }
                    gl.glVertex3f(v2._position.x, v2._position.y, v2._position.z);
                    ++i;
                }
                gl.glEnd();
            } else if (this._mat._type == Material.eMaterialType.MULTI) {
                MultiMaterial mmat = (MultiMaterial)this._mat;
                int i = 0;
                i = 0;
                while (i < mmat._numSubMaterials) {
                    StandardMaterial smat = (StandardMaterial)mmat._matList.get(i);
                    boolean hasTex = false;
                    try {
                        VTexture tex = smat._texList.get(0);
                        gl.glEnable(3553);
                        if (tex != null) {
                            gl.glBindTexture(3553, tex.getId());
                        }
                        hasTex = true;
                    }
                    catch (Exception e) {
                        hasTex = false;
                        gl.glDisable(3553);
                        gl.glBindTexture(3553, 0);
                    }
                    MeshChunk mc = this._chunkList.get(i);
                    int ti = 0;
                    gl.glBegin(4);
                    ti = 0;
                    while (ti < mc._triList.size()) {
                        Triangle t = mc._triList.get(ti);
                        Vertex v0 = this._vertexList.get(t._a);
                        Vertex v1 = this._vertexList.get(t._b);
                        Vertex v2 = this._vertexList.get(t._c);
                        gl.glColor4f(v0._color.x, v0._color.y, v0._color.z, v0._color.w);
                        gl.glNormal3f(v0._normal.x, v0._normal.y, v0._normal.z);
                        if (hasTex) {
                            gl.glTexCoord2f(v0._texCoord.x, v0._texCoord.y);
                        }
                        gl.glMultiTexCoord3f(33985, v0._tangent.x, v0._tangent.y, v0._tangent.z);
                        gl.glVertex3f(v0._position.x, v0._position.y, v0._position.z);
                        gl.glColor4f(v1._color.x, v1._color.y, v1._color.z, v1._color.w);
                        gl.glNormal3f(v1._normal.x, v1._normal.y, v1._normal.z);
                        if (hasTex) {
                            gl.glTexCoord2f(v1._texCoord.x, v1._texCoord.y);
                        }
                        gl.glMultiTexCoord3f(33985, v1._tangent.x, v1._tangent.y, v1._tangent.z);
                        gl.glVertex3f(v1._position.x, v1._position.y, v1._position.z);
                        gl.glColor4f(v2._color.x, v2._color.y, v2._color.z, v2._color.w);
                        gl.glNormal3f(v2._normal.x, v2._normal.y, v2._normal.z);
                        if (hasTex) {
                            gl.glTexCoord2f(v2._texCoord.x, v2._texCoord.y);
                        }
                        gl.glMultiTexCoord3f(33985, v2._tangent.x, v2._tangent.y, v2._tangent.z);
                        gl.glVertex3f(v2._position.x, v2._position.y, v2._position.z);
                        ++ti;
                    }
                    gl.glEnd();
                    ++i;
                }
            }
        }
    }

    public void render(GL gl) {
        int i = 0;
        if (this._mat != null) {
            if (this._mat._type == Material.eMaterialType.STANDARD) {
                StandardMaterial smat = (StandardMaterial)this._mat;
                boolean hasTex = true;
                try {
                    VTexture tex = smat._texList.get(0);
                    gl.glEnable(3553);
                    if (tex != null) {
                        gl.glBindTexture(3553, tex.getId());
                    }
                    hasTex = true;
                }
                catch (Exception e) {
                    hasTex = false;
                    gl.glDisable(3553);
                    gl.glBindTexture(3553, 0);
                }
                float[] amb = new float[]{smat._ambient.x, smat._ambient.y, smat._ambient.z, smat._ambient.w};
                float[] diff = new float[]{smat._diffuse.x, smat._diffuse.y, smat._diffuse.z, smat._diffuse.w};
                float[] spec = new float[]{smat._specular.x, smat._specular.y, smat._specular.z, smat._specular.w};
                float[] shininess = new float[]{smat._specularLevel};
                gl.glEnable(2903);
                FloatBuffer fb = FloatBuffer.wrap(amb);
                gl.glMaterialfv(1032, 4608, fb);
                fb = FloatBuffer.wrap(diff);
                gl.glMaterialfv(1032, 4609, fb);
                fb = FloatBuffer.wrap(spec);
                gl.glMaterialfv(1032, 4610, fb);
                fb = FloatBuffer.wrap(shininess);
                gl.glMaterialfv(1032, 5633, fb);
                gl.glBegin(4);
                i = 0;
                while (i < this._triangleList.size()) {
                    Triangle t = this._triangleList.get(i);
                    Vertex v0 = this._vertexList.get(t._a);
                    Vertex v1 = this._vertexList.get(t._b);
                    Vertex v2 = this._vertexList.get(t._c);
                    gl.glColor4f(v0._color.x, v0._color.y, v0._color.z, v0._color.w);
                    if (hasTex) {
                        gl.glTexCoord2f(v0._texCoord.x, v0._texCoord.y);
                    }
                    gl.glNormal3f(v0._normal.x, v0._normal.y, v0._normal.z);
                    gl.glVertex3f(v0._position.x, v0._position.y, v0._position.z);
                    gl.glColor4f(v1._color.x, v1._color.y, v1._color.z, v1._color.w);
                    if (hasTex) {
                        gl.glTexCoord2f(v1._texCoord.x, v1._texCoord.y);
                    }
                    gl.glNormal3f(v1._normal.x, v1._normal.y, v1._normal.z);
                    gl.glVertex3f(v1._position.x, v1._position.y, v1._position.z);
                    gl.glColor4f(v2._color.x, v2._color.y, v2._color.z, v2._color.w);
                    if (hasTex) {
                        gl.glTexCoord2f(v2._texCoord.x, v2._texCoord.y);
                    }
                    gl.glNormal3f(v2._normal.x, v2._normal.y, v2._normal.z);
                    gl.glVertex3f(v2._position.x, v2._position.y, v2._position.z);
                    ++i;
                }
                gl.glEnd();
            } else if (this._mat._type == Material.eMaterialType.MULTI) {
                i = 0;
                while (i < this._triangleList.size()) {
                    Triangle t = this._triangleList.get(i);
                    Vertex v0 = this._vertexList.get(t._a);
                    Vertex v1 = this._vertexList.get(t._b);
                    Vertex v2 = this._vertexList.get(t._c);
                    MultiMaterial mmat = (MultiMaterial)this._mat;
                    StandardMaterial smat = (StandardMaterial)mmat._matList.get(t._matId);
                    if (smat._texList != null) {
                        gl.glEnable(3553);
                        try {
                            VTexture tex = smat._texList.get(0);
                            if (tex != null) {
                                gl.glBindTexture(3553, tex.getId());
                            }
                        }
                        catch (Exception tex) {}
                    } else {
                        gl.glDisable(3553);
                        gl.glBindTexture(3553, 0);
                    }
                    float[] amb = new float[]{smat._ambient.x, smat._ambient.y, smat._ambient.z, smat._ambient.w};
                    float[] diff = new float[]{smat._diffuse.x, smat._diffuse.y, smat._diffuse.z, smat._diffuse.w};
                    float[] spec = new float[]{smat._specular.x, smat._specular.y, smat._specular.z, smat._specular.w};
                    float[] shininess = new float[]{smat._specularLevel};
                    gl.glEnable(2903);
                    FloatBuffer fb = FloatBuffer.wrap(amb);
                    gl.glMaterialfv(1032, 4608, fb);
                    fb = FloatBuffer.wrap(diff);
                    gl.glMaterialfv(1032, 4609, fb);
                    fb = FloatBuffer.wrap(spec);
                    gl.glMaterialfv(1032, 4610, fb);
                    fb = FloatBuffer.wrap(shininess);
                    gl.glMaterialfv(1032, 5633, fb);
                    gl.glBegin(4);
                    gl.glColor4f(v0._color.x, v0._color.y, v0._color.z, v0._color.w);
                    gl.glNormal3f(v0._normal.x, v0._normal.y, v0._normal.z);
                    gl.glTexCoord2f(v0._texCoord.x, v0._texCoord.y);
                    gl.glVertex3f(v0._position.x, v0._position.y, v0._position.z);
                    gl.glColor4f(v0._color.x, v0._color.y, v0._color.z, v0._color.w);
                    gl.glNormal3f(v1._normal.x, v1._normal.y, v1._normal.z);
                    gl.glTexCoord2f(v1._texCoord.x, v1._texCoord.y);
                    gl.glVertex3f(v1._position.x, v1._position.y, v1._position.z);
                    gl.glColor4f(v0._color.x, v0._color.y, v0._color.z, v0._color.w);
                    gl.glNormal3f(v2._normal.x, v2._normal.y, v2._normal.z);
                    gl.glTexCoord2f(v2._texCoord.x, v2._texCoord.y);
                    gl.glVertex3f(v2._position.x, v2._position.y, v2._position.z);
                    gl.glEnd();
                    ++i;
                }
            }
        }
    }

    public void renderVertexNormals(GL gl, float scal) {
        gl.glDisable(2896);
        gl.glDisable(3553);
        int i = 0;
        i = 0;
        while (i < this._vertexList.size()) {
            Vertex v0 = this._vertexList.get(i);
            Vector3 N = Vector3.mul(v0._normal, scal);
            gl.glBegin(1);
            gl.glColor4f(1.0f, 0.0f, 1.0f, 0.75f);
            gl.glVertex3f(v0._position.x, v0._position.y, v0._position.z);
            gl.glVertex3f(v0._position.x + N.x, v0._position.y + N.y, v0._position.z + N.z);
            gl.glEnd();
            ++i;
        }
    }

    public void renderVertexTangents(GL gl, float scal) {
        gl.glDisable(2896);
        gl.glDisable(3553);
        int i = 0;
        i = 0;
        while (i < this._vertexList.size()) {
            Vertex v0 = this._vertexList.get(i);
            Vector3 T = Vector3.mul(v0._tangent, scal);
            gl.glBegin(1);
            gl.glColor4f(0.0f, 1.0f, 0.0f, 0.75f);
            gl.glVertex3f(v0._position.x, v0._position.y, v0._position.z);
            gl.glVertex3f(v0._position.x + T.x, v0._position.y + T.y, v0._position.z + T.z);
            gl.glEnd();
            ++i;
        }
    }

    public void update(float time) {
        float timeClamped = 0.0f;
        timeClamped = time > 10.0f ? time % 10.0f : time;
        int key = 0;
        int key1 = 0;
        int key2 = 0;
        while (key < this._keys.size() && this._keys.get((int)key)._time < timeClamped) {
            ++key;
        }
        if (key < 0) {
            key = 0;
        }
        if (key >= this._keys.size()) {
            key = this._keys.size() - 1;
        }
        key1 = key - 1;
        key2 = key;
        if (key1 < 0) {
            ++key1;
            ++key2;
        }
        KeyFrame before = this._keys.get(key1);
        KeyFrame after = this._keys.get(key2);
        float t = (timeClamped - before._time) / (after._time - before._time);
        float d0 = before._vertWeights.get((int)0)._morphWeights[0];
        float d1 = after._vertWeights.get((int)0)._morphWeights[0];
        float dt = Linear.easeIn(t, d0, d1, Math.abs(d1 - d0));
        float dtcos = Sine.easeIn(t, d0, d1, Math.abs(d1 - d0));
        System.out.println(String.valueOf(key1) + ":" + key2 + " | time: " + time + ",  dt: " + dt + ",  dtcos: " + dtcos);
    }

    public void debug() {
        System.out.println("(Mesh)  ----------------------------");
        System.out.println("(Mesh)  mesh name: " + this._name);
        System.out.println("(Mesh)  num of vertices: " + this._vertexList.size());
        System.out.println("(Mesh)  num of triangles: " + this._triangleList.size());
        if (this._hasTriStrip) {
            System.out.println("(Mesh)  num of tristrips: " + this._triStripList.length);
        }
        System.out.println("(Mesh)  ----------------------------\n");
    }

    public String getName() {
        return this._name;
    }

    public boolean isVisible() {
        return this._isVisible;
    }

    public int getVertexCount() {
        return this._vertexList.size();
    }

    public int getTriangleCount() {
        return this._triangleList.size();
    }

    public Vertex getVertex(int idx) {
        return this._vertexList.get(idx);
    }

    public Triangle getTriangle(int idx) {
        return this._triangleList.get(idx);
    }

    public ArrayList<Vertex> getVertexList() {
        return this._vertexList;
    }

    public ArrayList<Triangle> getTriList() {
        return this._triangleList;
    }
}

