/**************************************************************

Shutter-rasters effect in 128 bytes for Commodore C16/Plus4/116
Coded by Andreas Gustafsson aka. Shadow/Noice in March 2009
andreas.gustafsson@gmail.com
http://ag1976.com

Assemble with Kick Assembler

Memory Map
----------
$1001-$100c Basic
$100d-$101a Table
$101b-$107e Code
**************************************************************/

.var shuttertab = $1100
.var cols = $1200
.var cols_orig = $1300

.pc = $1001 "Basic"
.byte $0b,$10,$01,$00,$9e,$34,$31,$32,$33,$00,$00,$00

	// Luminance table used in generating the color bars
	// Two of the zeroes from the above BASIC 'run' line
	// is used in the table as well to save some space.
.pc = * "Table"
bartab:
	.byte $10,$20,$30,$40,$50,$60,$70
	.byte $70,$60,$50,$40,$30,$20,$10


.pc = $101b "Code"

	sei
			
	// Create the shutter indexing table
	ldy #$10
tabloop:	
	tya
	asl
	sta val+1
	ldx #$10
val:	
	lda #$00
tabptr:
	sta shuttertab
	inc tabptr+1
	dec val+1
	dex
	bne val
	dey
	bne tabloop	
	
	// Create color bar table
col_loop:	
	txa
	lsr	
	and #$0f
	tay
	txa
	lsr
	lsr
	lsr
	lsr
	lsr
	asl	// This one is to get some more interesting colors, can be skipped to save one byte
   ora bartab-2,y
	sta cols_orig,x
	sta cols_orig+$100,x
	dex
	bne col_loop
	
	// Border over the entire screen
	stx $ff06		
	
	// Main raster code
main:
	lda $ff1c
	and #$01 // This seems to be necessary on real HW
	beq main
	lda #$20
wait:
	cmp $ff1d
   bne wait
loop:
	ldy shuttertab,x
	lda cols,y
	ldy #$12
delay:	
	dey
	bne delay
	sta $ff19,y
	inx
	bne loop	
	stx $ff19 // Set black screen after the 256 lines, this can be skipped to save three bytes but then you get a bit of flashing above and below the effect
	
	// Scroll the color bars
colpos:
	lda cols_orig,x
	sta cols,x
	dex
	bne colpos
	dec colpos+1	
	
	bvc main	