## .vert

uniform float anim;
uniform float begin;
uniform float end;
uniform float pointSize;
uniform float bright;
varying float brightness;

void main()
	{
	vec4 v = gl_Vertex;

	v.x += sin( sin( v.y ) * sin( anim ) );
	v.y += sin( sin( v.z ) * sin( anim * 1.1 ) );
	v.z += sin( sin( v.x ) * sin( anim * 1.2 ) );
	v.x += sin( cos( v.y ) * sin( anim * 1.32 ) );
	v.y += sin( cos( v.z ) * sin( anim * 1.25 ) );
	v.z += sin( cos( v.x ) * sin( anim * 1.16 ) );

	float pos = gl_Normal.x;
	if ( pos >= begin && pos <= end )
		{
		brightness = sin( anim * 10.0 + pos * 1000.0 ) * 0.5 + 0.5;
		gl_PointSize = 1.0 + ( 1.0 - brightness ) * pointSize;
		}
	else
		{
		brightness = 0.0;
		gl_PointSize = 0.0;
		}
	
	gl_Position = gl_ModelViewProjectionMatrix * v;
	}

## .frag

varying float brightness;

void main()
	{
	gl_FragColor = vec4( brightness, brightness * 0.9, brightness * 0.25, 0.2 );
	}