## .vert

uniform float anim;
uniform float pointSize;
uniform float yellow;
uniform float brightness;

varying vec4 col;

void main()
	{
	vec4 v = gl_Vertex;
	
	v.x += sin( sin( v.y ) * sin( anim ) );
	v.y += sin( sin( v.z ) * sin( anim * 1.1 ) );
	v.z += sin( sin( v.x ) * sin( anim * 1.2 ) );
	v.x += sin( cos( v.y ) * sin( anim * 1.32 ) );
	v.y += sin( cos( v.z ) * sin( anim * 1.25 ) );
	v.z += sin( cos( v.x ) * sin( anim * 1.16 ) );

	col = vec4( 0.0, 0.0, 0.0, 1.0 );
	vec3 ecPos3 = ( gl_ModelViewMatrix * v ).xyz;
	float z = abs( ecPos3.z ) * 0.3;
	float br = 0.0;

	if ( brightness > 0.0 )
		{
		float s1 = min( 0.2 * abs( v.z ) / length( v.xy ), 1.0 );
		float s2 = min( 0.2 * abs( v.y ) / length( v.xz ), 1.0 );
		float s3 = min( 0.2 * abs( v.x ) / length( v.yz ), 1.0 );
		float s = min( max( s1, max( s2, s3 ) ), 1.0 );
		s *= s;
		
		br = yellow / length( v );
		
		col.b = s;
		col.g = s * 0.4 + br * 0.4;
		col.r = s * s * 0.25 + br;
		col /= z * 0.25;
		col.a = 0.5 + br;
		col = min( col * brightness, 1.0 );
		}
	
	gl_Position = gl_ModelViewProjectionMatrix * v;
	gl_PointSize = min( pointSize / ( z * 0.5 ) + br, pointSize );
	gl_TexCoord[0].stpq = gl_MultiTexCoord0;
	}

## .frag

uniform sampler2D tex;
varying vec4 col;

void main()
	{
	gl_FragColor = col * texture2D( tex, gl_TexCoord[0].st );
	}