## build.vert

uniform float foo;
varying float alpha;
varying float diff;

void main()
	{
	alpha = clamp( 0.5 + 0.5 * sin( ( foo + gl_MultiTexCoord0.x ) * 5.0 ), 0.0, 1.0 );
	
	float l = length( gl_Vertex );
	vec4 v = gl_Vertex;
	v.x *= 0.8 + 0.4 * sin( l + foo );	
	v.y *= 0.8 + 0.4 * cos( ( l + foo ) * 1.2 );	
	v.z *= 0.8 + 0.4 * sin( ( l + 1.0 + foo ) * 0.8 );

	diff = clamp( dot( vec4(0.0), v ), 0.0, 1.0 );	
	gl_Position = gl_ModelViewProjectionMatrix * v;
	}

## buid.frag

varying float alpha;
varying float diff;

void main()
	{
	gl_FragColor = vec4( diff, diff, diff, alpha );
	}