## blury.vert

void main()
	{
	gl_Position = ftransform();
	gl_TexCoord[0].stpq = gl_MultiTexCoord0;
	}

## blury.frag

uniform sampler2D tex;
uniform float blur;
const float pixel = 1.0 / 360.0;

void main()
	{
	float fb = floor( blur );
	float div = fb * fb;
	vec2 coord = gl_TexCoord[0].st - vec2( 0.0, fb * pixel );
	vec4 color;
	float coef = 1.0;
	
	for ( float i = 0.0; i < fb; i++ )
		{
		vec2 c = coord;
		c.y = clamp( c.y, 0.0, 1.0 );
		color += texture2D( tex, c ) * coef;
		coord.y += pixel;
		coef += 1.0;
		}
	color += texture2D( tex, coord ) * coef;
	for ( float i = 0.0; i < fb; i++ )
		{
		coord.y += pixel;
		coef -= 1.0;
		vec2 c = coord;
		c.y = clamp( c.y, 0.0, 1.0 );
		color += texture2D( tex, c ) * coef;
		}
	
	color /= div;
	
	gl_FragColor = color;
	}