## blurx.vert

void main()
	{
	gl_Position = ftransform();
	gl_TexCoord[0] = gl_MultiTexCoord0;
	}

## blurx.frag

uniform sampler2D tex;
uniform float blur;
uniform float xpixel;
uniform float ypixel;
uniform float dx;
uniform float dy;
uniform float brightness;

vec2 delta = vec2( dx * xpixel, dy * ypixel );

void main()
	{
	float fb = floor( blur );
	float div = fb * fb;
	vec2 coord = gl_TexCoord[0].st - delta * fb;
	vec4 color;
	float coef = 1.0;
	
	for ( float i = 0.0; i < fb; i++ )
		{
		color += texture2D( tex, clamp( coord, 0.0, 1.0 ) ) * coef;
		coord += delta;
		coef += 1.0;
		}
	color += texture2D( tex, coord ) * coef;
	for ( float i = 0.0; i < fb; i++ )
		{
		coord += delta;
		coef -= 1.0;
		color += texture2D( tex, clamp( coord, 0.0, 1.0 ) ) * coef;
		}
	
	color /= div;
	color *= brightness;
	
	gl_FragColor = color;
	}