import java.util.*;
import java.io.*;


public class Modell {
	List punkteorig;
	List linien;
	int[][] punkte;
	double fpx =0;
	double fpy =0;
	double fpz =-1000;	
	
	private String datei1 = "punkte.txt";
	private String datei2 = "linien.txt";

	Modell() {
		punkteorig = new LinkedList();
		linien = new LinkedList();
		ladePunkte();
		ladeLinien();
		punkte = new int[punkteorig.size()][3];
	}
	Modell(String p,String l) {
		datei1 = p;
		datei2 = l;
		punkteorig = new LinkedList();
		linien = new LinkedList();
		ladePunkte();
		ladeLinien();
		punkte = new int[punkteorig.size()][3];
	}
	void dreheModellxyz(double wx, double wy, double wz){
		
		int s = punkteorig.size();
		for (int i = 0; i < s; i++) {
			Punkt xo= (Punkt)punkteorig.get(i);
			double a = Math.toRadians(wx);
			double b = Math.toRadians(wy);
			double c = Math.toRadians(wz);
			double x = COS(b)*(xo.x*COS(c) - xo.y*SIN(c)) + xo.z*SIN(b);
			double y = COS(a)*(xo.y*COS(c) + xo.x*SIN(c)) - SIN(a)*(xo.z*COS(b) + SIN(b)*(xo.y*SIN(c) - xo.x*COS(c)));	
			double z = COS(a)*(xo.z*COS(b) + SIN(b)*(xo.y*SIN(c) - xo.x*COS(c))) + SIN(a)*(xo.y*COS(c) + xo.x*SIN(c));
						
			// Tiefenskalierung
			// Abstand Punkt zu FP
			//double abstand0 = Math.sqrt(fpx*fpx+fpy*fpy+fpz*fpz);
			//double abstand = Math.sqrt((x-fpx)*(x-fpx)+(y-fpy)*(y-fpy)+(z-fpz)*(z-fpz));
		
			
			double abstand0 = Math.sqrt(fpz*fpz);
			double abstand = Math.sqrt((z-fpz)*(z-fpz));
		
			
			double scaler = abstand/abstand0;
			
			x = x*scaler;
			y = y*scaler;	
			/*
			System.out.println("x : "+x);
			System.out.println("y : "+y);
			System.out.println("scaler : "+scaler);
			System.out.println("abstand0 : "+abstand0);
			System.out.println("abstand : "+abstand);
			*/
			
			// Wertuebergabe
			punkte[i][0] = (int)x;
			punkte[i][1] = (int)y;
			punkte[i][2] = (int)z;		
		}
	}
	
	private double COS(double x){
		return Math.cos(x);
	}
	
	private double SIN(double x){
		return Math.sin(x);
	}

	void skaliereModell(double groesse) {
		int z = punkteorig.size();
		for (int a = 0; a < z; a++) {
			Punkt xo = (Punkt) punkteorig.get(a);
			xo.x = xo.x * groesse;
			xo.y = xo.y * groesse;
			xo.z = xo.z * groesse;
		}
	}

	void ladePunkte() {
		try {
			BufferedReader eingabe = new BufferedReader(new FileReader(datei1));
			String in = "";
			in = eingabe.readLine();
			while (in != null) {
				int sep1 = in.indexOf(';');
				int sep2 = in.indexOf(';', sep1 + 1);
				double z1 = Double.parseDouble(in.substring(0, sep1));
				double z2 = Double.parseDouble(in.substring(sep1 + 1, sep2));
				double z3 = Double.parseDouble(in.substring(sep2 + 1));
				punkteorig.add(new Punkt(z1, z2, z3));
				in = eingabe.readLine();
			}
			eingabe.close();
		} catch (IOException e) {
			System.out.println("Fehler beim Lesen der Datei " + datei1);
		}
	}

	void ladeLinien() {
		try {
			BufferedReader eingabe = new BufferedReader(new FileReader(datei2));
			String in = "";
			in = eingabe.readLine();
			while (in != null) {
				int sep1 = in.indexOf(';');
				int z1 = Integer.parseInt(in.substring(0, sep1));
				int z2 = Integer.parseInt(in.substring(sep1 + 1));
				linien.add(new Linie(z1, z2));
				in = eingabe.readLine();
			}
			eingabe.close();
		} catch (IOException e) {
			System.out.println("Fehler beim Lesen der Datei " + datei1);
		}
	}

	void ausgabe() {
		int z = punkteorig.size();
		for (int a = 0; a < z; a++) {
			Punkt x = (Punkt) punkteorig.get(a);
			System.out.println(x.x + " " + x.y + " " + x.z);
		}
		z = linien.size();
		for (int a = 0; a < z; a++) {
			Linie x = (Linie) linien.get(a);
			System.out.println(x.anfang + " " + x.ende);
		}
	}
}
