﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace DHAPP
{
    public partial class Main : Form
    {
        public Main()
        {
            InitializeComponent();
        }

        
        private void Button_browse_Click(object sender, EventArgs e)
        {

            string readpath = "";
            string tempname = "";

            bool NewNameClipped = false;

            UInt32 LongestDirectory = 0;
            UInt32 LongestFilename = 0;
            UInt32 NumOfUpper = 0;
            UInt32 NumOfLower = 0;
            UInt32 NumOfFiles = 0;
            UInt32 CountCharacters = 65;

            richTextBox_NewName.Text = "";

            FolderBrowserDialog FolderBrowserDialog1 = new FolderBrowserDialog();
            FolderBrowserDialog1.RootFolder = System.Environment.SpecialFolder.Desktop;
            FolderBrowserDialog1.SelectedPath = "c:\\";

            if ( FolderBrowserDialog1.ShowDialog() == DialogResult.OK )
            {
                listbox_files.Items.Clear();
                richTextBox_errors.Text = "";
                richTextBox_additional_info.Text = "";
                richTextBox_NewName.Text = "";
                
                readpath = FolderBrowserDialog1.SelectedPath.ToString();
                textBox_BrowsedFile.Text = readpath;
                string foldername = FolderBrowserDialog1.SelectedPath;

                foreach ( string f in Directory.GetFiles( foldername ) )
                {

                    if (f.Length > LongestFilename)
                        LongestFilename = Convert.ToUInt32( f.Length );
                    string[] words = f.Split( '\\' );
                    listbox_files.Items.Add( words[words.Length-1] );
                    char c = Convert.ToChar( words[words.Length - 1].Substring(0, 1) );
                    tempname += words[words.Length - 1].Substring(0, 1).ToUpper();
                    richTextBox_NewName.Text += c;
                    
                    NumOfLower += Convert.ToUInt32(char.IsLower(c) ? 1 : 0);
                    NumOfUpper += Convert.ToUInt32(char.IsUpper(c) ? 1 : 0);
                    
                    NumOfFiles++;

                }
                string[] words2 = textBox_BrowsedFile.Text.Split('\\');
                string newname = textBox_BrowsedFile.Text.Substring(0, textBox_BrowsedFile.Text.Length - words2[words2.Length - 1].Length);
                LongestDirectory = Convert.ToUInt32(newname.Length + richTextBox_NewName.Text.Length + LongestFilename);
                if (LongestDirectory > 259)
                {
                    NewNameClipped = true;
                    richTextBox_NewName.Text = richTextBox_NewName.Text.Substring(0, Convert.ToInt32(richTextBox_NewName.Text.Length - ( LongestDirectory - 259 )));
                }
                richTextBox_errors.Text = "The new  directory name-length of this folder will be: " + ( newname.Length + richTextBox_NewName.Text.Length );
                richTextBox_errors.Text += NewNameClipped ? "\nName of the folder has been shortened due to windows directory length limit" : "\nMax name-length possible for files in this folder due to windows length limit: " + ( 259 - (LongestDirectory - LongestFilename) ) + " (incl ext)";

                richTextBox_additional_info.Text = "Total amount of files in folder: " + NumOfFiles;
                richTextBox_additional_info.Text += "\n\nTotal amount of how many filenames begin with upper case letters: " + NumOfUpper;
                richTextBox_additional_info.Text += "\nTotal amount of how many filenames begin with lower case letters: " + NumOfLower + "\n";
                for ( UInt32 i = 0; i < 26; i++ )
                {

                    UInt32 temp = 0;
                    for ( int u = 0; u < tempname.Length; u++ )
                    {

                        temp += Convert.ToUInt32(tempname[u] == Convert.ToChar(CountCharacters + i) ? 1 : 0);

                    }

                    richTextBox_additional_info.Text += "\nTotal amount of how many filenames begin with the character " + Convert.ToChar(CountCharacters + i) + ": " + temp;
                    temp = 0;

                }
                
                button_accept.Enabled = true;
            }
        }

        private void textBox_BrowsedFile_TextChanged(object sender, EventArgs e)
        {

        }

        private void button_accept_Click(object sender, EventArgs e)
        {
            try
            {
                string[] words = textBox_BrowsedFile.Text.Split('\\');
                string newname = textBox_BrowsedFile.Text.Substring(0, textBox_BrowsedFile.Text.Length - words[words.Length - 1].Length);
                newname += richTextBox_NewName.Text;
                Directory.Move(textBox_BrowsedFile.Text, newname);
                textBox_BrowsedFile.Text = "";
                richTextBox_errors.Text = "";
                richTextBox_additional_info.Text = "";
                richTextBox_NewName.Text = "";
                button_accept.Enabled = false;
                MessageBox.Show("Name change succeeded", "Done!", MessageBoxButtons.OK);
            }
            catch (System.Exception ex)
            {
                MessageBox.Show("Name change failed, most likely cause you're missing permission", "Failed!", MessageBoxButtons.OK);
            }
        }

    }
}
