float4x4 World;
float4x4 View;
float4x4 Projection;
float4x4 NormalMatrix;
float4x4 WVP;
float3 CameraPosition;

float AmbientIntensity = 1;
float4 AmbientColor : AMBIENT = float4(0,0,0,1);
float3 LightDirection : Direction = float3(0,1,1);
float Alpha = 1.0;

#define BLUR_SAMPLES 15
float2 BlurOffsets[BLUR_SAMPLES];
float BlurWeights[BLUR_SAMPLES];

texture ColorMap : Diffuse;
sampler ColorMapSampler = sampler_state
{
    texture = <ColorMap>; MipFilter = Point; MinFilter = Point; MagFilter = Linear; AddressU  = Wrap; AddressV  = Wrap;

};

texture Texture1 : Diffuse;
sampler TextureSampler = sampler_state
{
 texture = <Texture1>; MipFilter = Linear; MinFilter = Linear; MagFilter = Linear; AddressU  = Wrap; AddressV  = Wrap;


};
texture TempTexture : Diffuse;
sampler TempTextureSampler = sampler_state
{
   texture = <TempTexture>;
    magfilter = POINT; 
    minfilter = POINT; 
    mipfilter = POINT;
};

struct VS_IN
{
    float4 Position : POSITION0;
    float4 Normal : NORMAL0;
    float2 TexCoord : TEXCOORD0;
	float4 Color : COLOR0;
};

struct VS_OUT
{
    float4 Position : POSITION;
    float2 TexCoord : TEXCOORD0;
    float3 Light : TEXCOORD1;
    float3 Normal : TEXCOORD2;   
    float3 ShadowCoord : TEXCOORD3;    
    float3 RealDistance: TEXCOORD4;
    float4 Color : COLOR0;
};

struct PS_OUT
{
    float4 Color : COLOR;
};

struct VertexShaderInputCombine
{
    float4 Position : POSITION0;
    float4 TexCoord : TEXCOORD0;
};

struct VertexShaderOutputCombine
{
    float4 Position : POSITION0;
	float4 TexCoord : TEXCOORD0;
	
};

struct PixelShaderOutput
{
	float4 Color : COLOR0;
};

VS_OUT VS_ColorMap(VS_IN input)
{
    VS_OUT output = (VS_OUT)0;
    output.Position = mul(input.Position, WVP);   
    output.Light = LightDirection;
    output.TexCoord = input.TexCoord;
    output.Normal = mul(input.Normal, NormalMatrix);
    return output;
}

PS_OUT PS_ColorMap(VS_OUT input)
{
    PS_OUT output = (PS_OUT)0;
    float3 LightDir = normalize(input.Light);
    float Diffuse = saturate(dot(LightDir, normalize(input.Normal)));
    float4 texCol = tex2D(ColorMapSampler,input.TexCoord);
    float4 Ambient = AmbientIntensity * AmbientColor;
    texCol *= Diffuse;
    //output.Color =  Ambient + texCol;
    output.Color = input.Color;
    output.Color.r = 1;
    output.Color.g = 1;
    output.Color.b = 1;
    return output;
}

VertexShaderOutputCombine VertexShader2D(VertexShaderInputCombine input)
{
	VertexShaderOutputCombine output = (VertexShaderOutputCombine)0;
	
	output.Position = input.Position;
	output.TexCoord = input.TexCoord;

	return output;
}

PixelShaderOutput PixelShader2D(VertexShaderOutputCombine input)
{
	PixelShaderOutput output = (PixelShaderOutput)0;
	output.Color = tex2D(TextureSampler, input.TexCoord);
	output.Color.a *= Alpha;
	return output;
}

PixelShaderOutput PixelShaderGlow(VertexShaderOutputCombine input)
{
	PixelShaderOutput output = (PixelShaderOutput)0;
	float3 col = tex2D(TextureSampler, input.TexCoord);
	float lum = saturate(col.r * 0.3 + col.g * 0.59 + col.b * 0.11);
	if ( lum > 0.7 )
	  output.Color = lum*2;
	else
	  output.Color = 0;
	output.Color.a = 1;
	return output;
}

float4 PixelShader2DAdd(VertexShaderOutputCombine input) : COLOR0
{
	float4 t1 = tex2D(TempTextureSampler, input.TexCoord);
	float4 t2 = tex2D(TextureSampler, input.TexCoord);
	float4 output = saturate(t1 + t2);
	output.a = t1.a;
    return output;
}

float4 PixelShaderBlur(VertexShaderOutputCombine input) : COLOR0
{
	float4 color = 0;	
	for ( int i = 0; i < BLUR_SAMPLES; i++ )
	{
		color += tex2D(TextureSampler, input.TexCoord + BlurOffsets[i]) * BlurWeights[i];
	}
	return color;
}

technique DiffuseTextured
{
	pass Pass0
	{
		VertexShader = compile vs_3_0 VS_ColorMap();
		PixelShader = compile ps_3_0 PS_ColorMap();
	}
}

technique TwoDee
{
    pass Pass0
    {
        VertexShader = compile vs_3_0 VertexShader2D();
        PixelShader = compile ps_3_0 PixelShader2D();
    }
}

technique Glow
{
    pass Pass0
    {
        VertexShader = compile vs_3_0 VertexShader2D();
        PixelShader = compile ps_3_0 PixelShaderGlow();
    }
}

technique GlowCombine
{
    pass Pass0
    {
        VertexShader = compile vs_3_0 VertexShader2D();
        PixelShader = compile ps_3_0 PixelShader2DAdd();
    }
}

technique BasicShaderBlur
{
    pass Pass0
    {
        VertexShader = compile vs_2_0 VertexShader2D();
        PixelShader = compile ps_2_0 PixelShaderBlur();
    }
}