
uniform sampler2D glowTexture;

vec2 offsets[12] = vec2[](
		vec2( -0.326212, -0.405805 ),
		vec2( -0.840144, -0.073580 ),
		vec2( -0.695914,  0.457137 ),
		vec2( -0.203345,  0.620716 ),
		vec2(  0.962340, -0.194983 ),
	  	vec2(  0.473434, -0.480026 ),
		vec2(  0.519456,  0.767022 ),
		vec2(  0.185461, -0.893124 ),
		vec2(  0.507431,  0.064425 ),
		vec2(  0.896420,  0.412458 ),
		vec2( -0.321940, -0.932615 ),
		vec2( -0.791559, -0.597705 ) );

const float BlurScale = 0.01;

float raw_noise(int x, int y, int random) {
	float ret;
	int n = x + y * 57 + random * 131;
	n = (n<<13) ^ n;
	ret = (1.0f - ( (n * (n * n * 15731 + 789221) + 1376312589)&0x7fffffff)* 0.000000000931322574615478515625f);
	return ret;
}

void main()
{
	vec2 texCoord = gl_TexCoord[0].st;
	vec4 default_sum = texture2D(glowTexture, texCoord);
	vec4 sum = texture2D(glowTexture, texCoord);

		int i = 0;
		for( i = 0; i < 12; i++ ) {
			sum += texture2D( glowTexture, texCoord + BlurScale * offsets[i] );
		}
		gl_FragColor = sum / 12.0 - vec4(0.1,0.0,0.0,0.5);
	/*	
	if(default_sum.y > 0.1 && default_sum.z < 0.2) {
		gl_FragColor = vec4(0,0,sin(texCoord.x*texCoord.y*30),0);
	}
	*/

	if(default_sum.y > 0.1) {
		gl_FragColor += vec4(0,cos(texCoord.x*texCoord.y),cos(texCoord.x*texCoord.y),sin(texCoord.x*texCoord.y));
	}

	if(default_sum.z == 1)
	      gl_FragColor = vec4(0,0,0,1);

	if(sum.x > 0.8)
		gl_FragColor = vec4(0.7,1,0.7,1);

		gl_FragColor = vec4(gl_FragColor.z*0.8,gl_FragColor.z*0.8,gl_FragColor.z,1);

}

