/*
 * Main.fx
 *
 * Created on 07.05.2009, 19:24:29
 */

package samples.physics;

import javafx.stage.*;

import javafx.scene.*;
import javafx.scene.paint.*;
import javafx.scene.shape.*;
import javafx.scene.transform.*;
import javafx.animation.*;

import physics.classical.object.*;
import mathematics.multidimensional.dim3.*;


import javafx.util.Math;


class Stars extends CustomNode {

    public override function create(): Node {
        Group {
            content: for(i in  [1..15])
                Circle{
                    centerX: Math.random() * 300 - 150
                    centerY: Math.random() * 300 - 150
                    radius: 2
                    fill: Color.WHITE
                }
        };
    }
}



var solarSystem = PhysicalObjectSystem{
    objects: [
        PhysicalObject{
            name: "Sun"
            mass : 2e30
            color: Color.YELLOW
            radius:   14000
            coordinate : VectorDim3{}
            velocity : VectorDim3{}
        },PhysicalObject{
            name: "Mercury"
            mass : 3.3e23
            color: Color.BLUE
            radius: 2400
            coordinate : VectorDim3{ elems:[ -57e9 ,  0, 0] }
            velocity : VectorDim3{ elems: [ 0, -47e3, 0 ] }
        },
        PhysicalObject{
            name: "Venus"
            mass : 4.8e24
            color: Color.PINK
            radius: 6000
            coordinate : VectorDim3{ elems: [ 108e9 ,  0, 0] }
            velocity : VectorDim3{ elems: [ 0, 35e3, 0 ] }
        },
        PhysicalObject{
            name: "Earth"
            mass : 6e24
            color: Color.GREEN
            radius: 6300
            coordinate : VectorDim3{ elems: [ 0 , -150e9, 0 ] }
            velocity : VectorDim3{ elems: [ 30e3, 0, 0 ] }
        },PhysicalObject{
            name: "Mars"
            mass : 6.4e23
            color: Color.RED
            radius: 3400
            coordinate : VectorDim3{ elems: [ 0 , 228e9, 0 ] }
            velocity : VectorDim3{ elems: [ -24e3, 0, 0 ] }
        }
    ]
};


Timeline {
    repeatCount: Timeline.INDEFINITE
    keyFrames:  KeyFrame {
        time: 0.02s
        action: function() { solarSystem.run(); }
    }
}.play();


var w = 600;
var h = 400;

Stage {
    title: "Solar System"
    width: w
    height: h
    scene: Scene{
        content: Group{
           transforms: Transform.translate(w/2, h/2)
           content: [ Stars{}, solarSystem ]
        }
        fill: Color.BLACK
    }
}