/*
 * Battary.fx
 *
 * Created on Aug 6, 2009, 5:48:35 PM
 */

package physics.electronic;

import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;

/**
 * @author andromeda
 */

//  ============  Battery ====================//


public class Battery extends  ElectronicComponent {

    override var name = "Battery";

    override var pin1 on replace oldPin=newPin {
       pin1.pos = XY {x: bind pos.x + compWidth - 5  y: bind pos.y - compHeight};
    }

    override var pin2 on replace oldPin=newPin {
      pin2.pos = XY{x: bind pos.x - compWidth + 5  y: bind pos.y - compHeight};
    }


    override function simulate():Void{
      pin1.level =  3.0;
      pin2.level = -3.0;
    }

    override function create():Node{
      var w = compWidth;
      var h = compHeight;

      return Group{
        content: [Rectangle{
            x: bind pos.x - w
            y: bind pos.y - h
            width:  2 * w
            height: 2 * h
            fill: Color.CHOCOLATE
            stroke: Color.BROWN
        },Line{
            startX: bind pos.x + w - 5 + 3
            startY: bind pos.y - h + 10
            endX: bind pos.x + w - 5 - 3
            endY: bind pos.y - h  + 10

            stroke: Color.DARKBLUE
            strokeWidth: 2
        },Line{
            startX: bind pos.x - w + 5 + 3
            startY: bind pos.y - h + 10
            endX: bind pos.x - w  + 5 - 3
            endY: bind pos.y - h  + 10

            stroke: Color.DARKBLUE
            strokeWidth: 2
        },Line{
            startX: bind pos.x - w + 5
            startY: bind pos.y - h + 10 + 3
            endX: bind pos.x - w  + 5
            endY: bind pos.y - h  + 10 -3

            stroke: Color.DARKBLUE
            strokeWidth: 2
        },pin1, pin2]
         onMouseDragged: function(e: MouseEvent){
            pos.x = e.x;
            pos.y = e.y;
         }
      };
    }

}
