/*
 * MDSphera.fx
 *
 * Created on 24.07.2009, 22:49:13
 */

package mathematics.multidimensional.shape;


import javafx.util.Math;
import mathematics.multidimensional.*;

/**
 * @author raindrop
 */


public function coordinate(radius:Number, angle:IMDVector):IMDVector{


    var dim = angle.getDim();

    if(dim == 0){ return MDVector{ dim: 1 elems: [radius] } }

    var alpha = angle.getElem( dim - 1 );



    MDVector{
        dim: dim + 1
        elems: [MDVector.getElems(coordinate(radius * Math.sin(alpha), angle.subVector(dim-1))), radius * Math.cos(alpha)]
    }

}


public class MDSphere extends MDShape{


    public var radius:Number;


    override var fragmentation = 6;

//    public override function getPoints():MDPoint[]{
//
//        def PI = Math.PI;
//
//        for(v in MDSet.set(-PI, PI, N, dim -1)){
//            MDPoint.createPoint(coordinate(radius, v))
//        }
//    }

    public override function getSegments(): MDSegment[]{



        var N = fragmentation;

        def PI = Math.PI;

        var delta = 2.0 * PI / (2 * N);
        
        //println("[sphere] delta: {delta}");
        //println("[sphere] fragmentation: {fragmentation}");


        for(angle in MDSet.set(-PI, PI, N, dim -1)){
            var center = MDPoint.createPoint(coordinate(radius, angle));
            //println("");
            //println("[sphere] angle: {angle}");;
            //println("[sphere] center: {center}");;

            for(p in MDVector.getNeighborhood(delta, angle)){
            //for(p in MDVector.getPositiveNeighborhood(delta, angle)){
                //println("[sphere] neigh: dim: {p.getDim()}, {p}");;


                MDSegment{
                    point1: center
                    point2: MDPoint.createPoint(coordinate(radius, p))
                }

            }
           
        }
    }

    
}
