package mathematics.multidimensional;

import mathematics.multidimensional.MDMatrix;

/**
 * @author Alexandr Scherbatiy
 */

 
public class MDSquareMatrix extends AMDSquareMatrix, ICMDSquareMatrix{

//public class MDSquareMatrix extends AMDSquareMatrix, IMDSquareMatrix{


    public var elems:Number[] ;

    override function getElem (n:Integer, m: Integer):Number {
        return elems[dim * n + m ];
    }

    override override function setElem (n:Integer, m: Integer, value:Number){
        elems[dim * n + m ] = value;
    }

    override function setRow(n:Integer, row:IMDVector){
        MDMatrix.setRow(n, row, this);
    }

    override function setColumn(m:Integer, column:IMDVector){
        MDMatrix.setColumn(m, column, this);
    }

}


public function getCSquareMatrix(matrix:IMDSquareMatrix):ICMDSquareMatrix{

    var dim = matrix.getDim();


    MDSquareMatrix{
        dim: dim
        
        elems: for(n in [0..dim-1]){
            for(m in [0..dim-1]){
                matrix.getElem(n,m)
            }

        }
    }

}
