package mathematics.multidimensional;

/**
 * @author Alexandr Scherbatiy
 */

 
public class MDMatrix extends AMDMatrix, ICMDMatrix{
        
    public var elems:Number[] ;

    override function getElem (n:Integer, m: Integer):Number {
        return elems[dimM * n + m ];
    }

    override function setElem (n:Integer, m: Integer, value:Number){
        elems[dimM * n + m ] = value;
    }

    override function setRow(n:Integer, row:IMDVector){
        for(m in [0..dimM-1]) {
            setElem(n, m, row.getElem(m));
        }
    }

    override function setColumn(m:Integer, column:IMDVector){
        for(n in [0..dimN-1]) {
            setElem(n, m, column.getElem(m));
        }
    }

    

}


public function mul(matrix1:IMDMatrix, matrix2:IMDMatrix):IMDMatrix {

    var N = matrix1.getDimN();
    var K = matrix1.getDimM();

    var M = matrix2.getDimM();

    MDMatrix{
        
        dimN: N
        dimM: M

        elems: for(n in [0..N-1]){
            for(m in [0..M-1]){
                var elem = 0.0;
                for(k in [0..K-1]){
                    elem += matrix1.getElem(n,k) * matrix2.getElem(k,m)
                }
                elem
            }

        }


    }

}


public function getRow(n:Integer, matrix:IMDMatrix):IMDVector{
    var dim = matrix.getDimM();
    MDVector{
        dim: dim
        elems: for(m in [0..dim-1])  matrix.getElem(n, m)
    }
}

public function getColumn(m:Integer, matrix:IMDMatrix):IMDVector{
    var dim = matrix.getDimN();
    MDVector{
        dim: dim
        elems: for(n in [0..dim-1])  matrix.getElem(n, m)
    }
}

public function setRow(n:Integer, row:IMDVector, matrix:ICMDMatrix){
    for(m in [0..matrix.getDimM()-1]) {
        matrix.setElem(n, m, row.getElem(m));
    }
}

public function setColumn(m:Integer, column:IMDVector, matrix:ICMDMatrix){
        for(n in [0..matrix.getDimN()-1]) {
            matrix.setElem(n, m, column.getElem(n));
        }
}

public function getCMatrix(matrix:IMDMatrix):ICMDMatrix{

    var dimN = matrix.getDimN();
    var dimM = matrix.getDimM();


    MDMatrix{
        dimN: dimN
        dimM: dimM

        elems: for(n in [0..dimN-1]){
            for(m in [0..dimM-1]){
                matrix.getElem(n,m)
            }

        }


    }

}
