/*
 * AMDTransform.fx
 *
 * Created on 07.05.2009, 23:39:12
 */

package mathematics.multidimensional;

/**
 * @author raindrop
 */

public mixin class AMDTransform extends IMDTransform{

    public var dimN:Integer;
    public var dimM:Integer;

    public override function getDimN ():Integer{ dimN }
    public override function getDimM ():Integer{ dimM }


     public override function innerProduct(v1:IMDVector, v2:IMDVector):Number{
         var v = transform(v2);
         var s = 0.0;

         for(n in [0..getDimN() - 1]){ s += v.getElem(n) * v1.getElem(n); }
         
         return s;
     }

     public override function mul(transform:IMDTransform):IMDTransform{
        var  T1 = transform;
        var  T2 = this;

        AMDTransform{
            dimN: T2.getDimN()
            dimM: T1.getDimM()

            override function transform(vector: IMDVector):IMDVector{
                T2.transform(T1.transform(vector));
            }

        }

     }


     //public override function toString() {

     //}
}

